/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.eco;

import ec.tstoolkit.eco.ILikelihood;

public class DefaultLikelihoodEvaluation<L extends ILikelihood> {
    private boolean m_ml = true;
    private boolean m_llog = true;
    private final L m_ll;

    public DefaultLikelihoodEvaluation(L ll) {
        this.m_ll = ll;
    }

    public double[] getE() {
        if (this.m_ll == null) {
            return null;
        }
        double[] err = this.m_ll.getResiduals();
        if (this.m_ml && this.m_ll.getFactor() != 1.0) {
            err = (double[])err.clone();
            double sqrfactor = Math.sqrt(this.m_ll.getFactor());
            int i = 0;
            while (i < err.length) {
                int n = i++;
                err[n] = err[n] * sqrfactor;
            }
        }
        return err;
    }

    public L getLikelihood() {
        return this.m_ll;
    }

    public double getSsqValue() {
        if (this.m_ll == null) {
            return Double.NaN;
        }
        return this.m_ml ? this.m_ll.getSsqErr() * this.m_ll.getFactor() : this.m_ll.getSsqErr();
    }

    public double getValue() {
        if (this.m_ll == null) {
            return Double.NaN;
        }
        if (this.m_llog) {
            return this.m_ml ? -this.m_ll.getLogLikelihood() : Math.log(this.m_ll.getSsqErr());
        }
        return this.m_ml ? this.m_ll.getSsqErr() * this.m_ll.getFactor() : this.m_ll.getSsqErr();
    }

    public boolean isUsingLogLikelihood() {
        return this.m_llog;
    }

    public boolean isUsingML() {
        return this.m_ml;
    }

    public void useLogLikelihood(boolean value) {
        this.m_llog = value;
    }

    public void useML(boolean value) {
        this.m_ml = value;
    }
}

