/*
 * Decompiled with CFR 0.152.
 */
package jdr.spec.tramoseats;

import ec.tstoolkit.modelling.TsVariableDescriptor;
import ec.tstoolkit.modelling.arima.tramo.TramoSpecification;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.regression.OutlierDefinition;
import jd2.information.InformationExtractor;
import jdr.spec.tramoseats.BaseTramoSpec;
import jdr.spec.tramoseats.CalendarSpec;
import jdr.spec.ts.Utility;

public class RegressionSpec
extends BaseTramoSpec {
    private ec.tstoolkit.modelling.arima.tramo.RegressionSpec inner() {
        return this.core.getRegression();
    }

    public RegressionSpec(TramoSpecification spec) {
        super(spec);
    }

    public int getPrespecifiedOutliersCount() {
        return this.inner().getOutliersCount();
    }

    public Utility.Outlier getPrespecifiedOutlier(int i) {
        OutlierDefinition[] outliers = this.inner().getOutliers();
        if (outliers == null || i >= outliers.length) {
            return null;
        }
        OutlierDefinition cur = outliers[i];
        String pos = Utility.toString(cur.getPosition());
        double[] c = this.inner().getFixedCoefficients(Utility.outlierName(cur.getCode(), pos, 0));
        Utility.Outlier o = new Utility.Outlier(cur.getCode(), pos, c == null ? 0.0 : c[0]);
        return o;
    }

    public void clearPrespecifiedOutliers() {
        this.inner().clearOutliers();
    }

    public void addPrespecifiedOutlier(String code, String date, double coef) {
        Day pos = Utility.of(date);
        OutlierDefinition def = new OutlierDefinition(pos, code);
        this.inner().add(def);
        if (coef != 0.0 && Double.isFinite(coef)) {
            String on = Utility.outlierName(code, date, 0);
            this.inner().setFixedCoefficients(on, new double[]{coef});
        }
    }

    public int getUserDefinedVariablesCount() {
        return this.inner().getUserDefinedVariablesCount();
    }

    public Utility.UserDefinedVariable getUserDefinedVariable(int i) {
        TsVariableDescriptor[] vars = this.inner().getUserDefinedVariables();
        if (vars == null || i >= vars.length) {
            return null;
        }
        TsVariableDescriptor desc = vars[i];
        double[] c = this.inner().getFixedCoefficients(desc.getName());
        return new Utility.UserDefinedVariable(desc.getName(), desc.getEffect().name(), c == null ? 0.0 : c[0]);
    }

    public void clearUserDefinedVariables() {
        this.inner().clearUserDefinedVariables();
    }

    public void addUserDefinedVariable(String name, String effect, double coef) {
        TsVariableDescriptor desc = new TsVariableDescriptor(InformationExtractor.concatenate("r", name));
        desc.setEffect(TsVariableDescriptor.UserComponentType.from((String)effect));
        this.inner().add(desc);
        if (coef != 0.0 && Double.isFinite(coef)) {
            this.inner().setFixedCoefficients("r@" + name, new double[]{coef});
        }
    }

    public CalendarSpec getCalendar() {
        return new CalendarSpec(this.core);
    }
}

