/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.satoolkit.diagnostics.FriedmanTest;
import ec.tstoolkit.modelling.arima.IPreprocessingModule;
import ec.tstoolkit.modelling.arima.ISeasonalityDetector;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.tramo.SeasonalityTests;
import ec.tstoolkit.stats.StatisticalTest;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsFrequency;

public class SeasonalityDetector
implements ISeasonalityDetector,
IPreprocessingModule {
    private static final String SEASONALITY_TESTS = "Seasonality tests";
    private SeasonalityTests tests;
    private int ost;
    private static final String SMODEL = "Model with seasonal part";
    private static final String NSMODEL = "Model without seasonal part";

    public SeasonalityTests getTests() {
        return this.tests;
    }

    @Override
    public boolean hasSeasonality(ModelDescription desc) {
        TsData y = desc.transformedOriginal();
        return this.hasSeasonality(y);
    }

    public boolean hasSeasonality(TsData y) {
        this.ost = 0;
        if (y.getFrequency() == TsFrequency.Yearly) {
            return false;
        }
        this.tests = new SeasonalityTests();
        this.tests.test(y, 1, true);
        int ost95 = 0;
        int cqs = 0;
        int cnp = 0;
        StatisticalTest qs = this.tests.getQs();
        FriedmanTest np = this.tests.getNonParametricTest();
        if (qs.getPValue() < 0.01) {
            cqs = 2;
            ++this.ost;
            ++ost95;
        } else if (qs.getPValue() < 0.05) {
            cqs = 1;
            ++ost95;
        }
        if (np.getPValue() < 0.01) {
            cnp = 2;
            ++this.ost;
            ++ost95;
        } else if (np.getPValue() < 0.05) {
            cnp = 1;
            ++ost95;
        }
        return cqs == 2 || ost95 == 2;
    }

    @Override
    public ProcessingResult process(ModellingContext context) {
        context.hasseas = this.hasSeasonality(context.description);
        context.originalSeasonalityTest = this.ost;
        this.addTestsInfo(context);
        this.addSeasInfo(context);
        return ProcessingResult.Changed;
    }

    private void addTestsInfo(ModellingContext context) {
    }

    private void addSeasInfo(ModellingContext context) {
    }
}

