/*
 * Decompiled with CFR 0.152.
 */
package ij.text;

import ij.IJ;
import ij.ImageJ;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.YesNoCancelDialog;
import ij.io.OpenDialog;
import ij.macro.Interpreter;
import ij.plugin.filter.Analyzer;
import ij.text.TextPanel;
import java.awt.CheckboxMenuItem;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class TextWindow
extends Frame
implements ActionListener,
FocusListener,
ItemListener {
    public static final String LOC_KEY = "results.loc";
    public static final String WIDTH_KEY = "results.width";
    public static final String HEIGHT_KEY = "results.height";
    public static final String LOG_LOC_KEY = "log.loc";
    public static final String DEBUG_LOC_KEY = "debug.loc";
    static final String FONT_SIZE = "tw.font.size";
    static final String FONT_ANTI = "tw.font.anti";
    TextPanel textPanel;
    CheckboxMenuItem antialiased;
    int[] sizes = new int[]{9, 10, 11, 12, 13, 14, 16, 18, 20, 24, 36, 48, 60, 72};
    int fontSize = (int)Prefs.get("tw.font.size", 5.0);
    MenuBar mb;

    public TextWindow(String string, String string2, int n, int n2) {
        this(string, "", string2, n, n2);
    }

    public TextWindow(String string, String string2, String string3, int n, int n2) {
        super(string);
        Object object;
        this.enableEvents(64L);
        if (IJ.isLinux()) {
            this.setBackground(ImageJ.backgroundColor);
        }
        this.textPanel = new TextPanel(string);
        this.textPanel.setTitle(string);
        this.add("Center", this.textPanel);
        this.textPanel.setColumnHeadings(string2);
        if (string3 != null && !string3.equals("")) {
            this.textPanel.append(string3);
        }
        this.addKeyListener(this.textPanel);
        ImageJ imageJ = IJ.getInstance();
        if (imageJ != null && (object = imageJ.getIconImage()) != null) {
            try {
                this.setIconImage((Image)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.addFocusListener(this);
        this.addMenuBar();
        this.setFont();
        WindowManager.addWindow(this);
        object = null;
        int n3 = 0;
        int n4 = 0;
        if (string.equals("Results")) {
            object = Prefs.getLocation(LOC_KEY);
            n3 = (int)Prefs.get(WIDTH_KEY, 0.0);
            n4 = (int)Prefs.get(HEIGHT_KEY, 0.0);
        } else if (string.equals("Log")) {
            object = Prefs.getLocation(LOG_LOC_KEY);
            n3 = n;
            n4 = n2;
        } else if (string.equals("Debug")) {
            object = Prefs.getLocation(DEBUG_LOC_KEY);
            n3 = n;
            n4 = n2;
        }
        if (object != null && n3 > 0 && n4 > 0) {
            this.setSize(n3, n4);
            this.setLocation((Point)object);
        } else {
            this.setSize(n, n2);
            GUI.center(this);
        }
        this.show();
    }

    public TextWindow(String string, int n, int n2) {
        super("");
        this.enableEvents(64L);
        this.textPanel = new TextPanel();
        this.add("Center", this.textPanel);
        if (this.openFile(string)) {
            WindowManager.addWindow(this);
            this.setSize(n, n2);
            this.show();
        } else {
            this.dispose();
        }
    }

    void addMenuBar() {
        this.mb = new MenuBar();
        if (Menus.getFontSize() != 0) {
            this.mb.setFont(Menus.getFont());
        }
        Menu menu = new Menu("File");
        menu.add(new MenuItem("Save As...", new MenuShortcut(83)));
        if (this.getTitle().equals("Results")) {
            menu.add(new MenuItem("Rename..."));
            menu.add(new MenuItem("Duplicate..."));
        }
        menu.addActionListener(this);
        this.mb.add(menu);
        menu = new Menu("Edit");
        menu.add(new MenuItem("Cut", new MenuShortcut(88)));
        menu.add(new MenuItem("Copy", new MenuShortcut(67)));
        menu.add(new MenuItem("Clear"));
        menu.add(new MenuItem("Select All", new MenuShortcut(65)));
        menu.addActionListener(this);
        this.mb.add(menu);
        menu = new Menu("Font");
        menu.add(new MenuItem("Make Text Smaller"));
        menu.add(new MenuItem("Make Text Larger"));
        menu.addSeparator();
        this.antialiased = new CheckboxMenuItem("Antialiased", Prefs.get(FONT_ANTI, IJ.isMacOSX()));
        this.antialiased.addItemListener(this);
        menu.add(this.antialiased);
        menu.add(new MenuItem("Save Settings"));
        menu.addActionListener(this);
        this.mb.add(menu);
        if (this.getTitle().equals("Results")) {
            menu = new Menu("Results");
            menu.add(new MenuItem("Clear Results"));
            menu.add(new MenuItem("Summarize"));
            menu.add(new MenuItem("Distribution..."));
            menu.add(new MenuItem("Set Measurements..."));
            menu.add(new MenuItem("Options..."));
            menu.addActionListener(this);
            this.mb.add(menu);
        }
        this.setMenuBar(this.mb);
    }

    public void append(String string) {
        this.textPanel.append(string);
    }

    void setFont() {
        this.textPanel.setFont(new Font("SanSerif", 0, this.sizes[this.fontSize]), this.antialiased.getState());
    }

    boolean openFile(String string) {
        OpenDialog openDialog = new OpenDialog("Open Text File...", string);
        String string2 = openDialog.getDirectory();
        String string3 = openDialog.getFileName();
        if (string3 == null) {
            return false;
        }
        string = string2 + string3;
        IJ.showStatus("Opening: " + string);
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string2 + string3));
            this.load(bufferedReader);
            bufferedReader.close();
        }
        catch (Exception exception) {
            IJ.error(exception.getMessage());
            return true;
        }
        this.textPanel.setTitle(string3);
        this.setTitle(string3);
        IJ.showStatus("");
        return true;
    }

    public TextPanel getTextPanel() {
        return this.textPanel;
    }

    public void load(BufferedReader bufferedReader) throws IOException {
        String string;
        boolean bl = false;
        while ((string = bufferedReader.readLine()) != null) {
            this.textPanel.appendLine(string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Make Text Larger")) {
            this.changeFontSize(true);
        } else if (string.equals("Make Text Smaller")) {
            this.changeFontSize(false);
        } else if (string.equals("Save Settings")) {
            this.saveSettings();
        } else {
            this.textPanel.doCommand(string);
        }
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        int n = windowEvent.getID();
        if (n == 201) {
            this.close();
        } else if (n == 205) {
            WindowManager.setWindow(this);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.setFont();
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean bl) {
        if (this.getTitle().equals("Results")) {
            if (bl && !Analyzer.resetCounter()) {
                return;
            }
            IJ.setTextPanel(null);
            Prefs.saveLocation(LOC_KEY, this.getLocation());
            Dimension dimension = this.getSize();
            Prefs.set(WIDTH_KEY, dimension.width);
            Prefs.set(HEIGHT_KEY, dimension.height);
        } else if (this.getTitle().equals("Log")) {
            Prefs.saveLocation(LOG_LOC_KEY, this.getLocation());
            IJ.debugMode = false;
            IJ.log("\\Closed");
            IJ.notifyEventListeners(3);
        } else if (this.getTitle().equals("Debug")) {
            Prefs.saveLocation(DEBUG_LOC_KEY, this.getLocation());
        } else if (this.textPanel != null && this.textPanel.rt != null && !this.saveContents()) {
            return;
        }
        this.setVisible(false);
        this.dispose();
        WindowManager.removeWindow(this);
        this.textPanel.flush();
    }

    public void rename(String string) {
        this.textPanel.rename(string);
    }

    boolean saveContents() {
        boolean bl;
        int n = this.textPanel.getLineCount();
        if (!this.textPanel.unsavedLines) {
            n = 0;
        }
        ImageJ imageJ = IJ.getInstance();
        boolean bl2 = bl = IJ.macroRunning() || Interpreter.isBatchMode();
        if (n > 0 && !bl && imageJ != null && !imageJ.quitting()) {
            YesNoCancelDialog yesNoCancelDialog = new YesNoCancelDialog((Frame)this, this.getTitle(), "Save " + n + " measurements?");
            if (yesNoCancelDialog.cancelPressed()) {
                return false;
            }
            if (yesNoCancelDialog.yesPressed() && !this.textPanel.saveAs("")) {
                return false;
            }
        }
        this.textPanel.rt.reset();
        return true;
    }

    void changeFontSize(boolean bl) {
        int n = this.fontSize++;
        if (bl) {
            if (this.fontSize == this.sizes.length) {
                this.fontSize = this.sizes.length - 1;
            }
        } else {
            --this.fontSize;
            if (this.fontSize < 0) {
                this.fontSize = 0;
            }
        }
        IJ.showStatus(this.sizes[this.fontSize] + " point");
        this.setFont();
    }

    void saveSettings() {
        Prefs.set(FONT_SIZE, this.fontSize);
        Prefs.set(FONT_ANTI, this.antialiased.getState());
        IJ.showStatus("Font settings saved (size=" + this.sizes[this.fontSize] + ", antialiased=" + this.antialiased.getState() + ")");
    }

    public void focusGained(FocusEvent focusEvent) {
        WindowManager.setWindow(this);
    }

    public void focusLost(FocusEvent focusEvent) {
    }
}

