/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.CompositeImage;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.gui.TrimmedButton;
import ij.gui.YesNoCancelDialog;
import ij.measure.Calibration;
import ij.plugin.frame.ContrastPlot;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.plugin.frame.TrimmedLabel;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import ij.process.StackStatistics;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;

public class ContrastAdjuster
extends PlugInFrame
implements Runnable,
ActionListener,
AdjustmentListener,
ItemListener {
    public static final String LOC_KEY = "b&c.loc";
    static final int AUTO_THRESHOLD = 5000;
    static final String[] channelLabels = new String[]{"Red", "Green", "Blue", "Cyan", "Magenta", "Yellow", "All"};
    static final String[] altChannelLabels = new String[]{"Channel 1", "Channel 2", "Channel 3", "Channel 4", "Channel 5", "Channel 6", "All"};
    static final int[] channelConstants = new int[]{4, 2, 1, 3, 5, 6, 7};
    static final String[] ranges = new String[]{"Automatic", "8-bit (0-255)", "10-bit (0-1023)", "12-bit (0-4095)", "15-bit (0-32767)", "16-bit (0-65535)"};
    ContrastPlot plot = new ContrastPlot();
    Thread thread;
    private static Frame instance;
    int minSliderValue = -1;
    int maxSliderValue = -1;
    int brightnessValue = -1;
    int contrastValue = -1;
    int sliderRange = 256;
    boolean doAutoAdjust;
    boolean doReset;
    boolean doSet;
    boolean doApplyLut;
    Panel panel;
    Panel tPanel;
    Button autoB;
    Button resetB;
    Button setB;
    Button applyB;
    int previousImageID;
    int previousType;
    int previousSlice = 1;
    Object previousSnapshot;
    ImageJ ij;
    double min;
    double max;
    double previousMin;
    double previousMax;
    double defaultMin;
    double defaultMax;
    int contrast;
    int brightness;
    boolean RGBImage;
    Scrollbar minSlider;
    Scrollbar maxSlider;
    Scrollbar contrastSlider;
    Scrollbar brightnessSlider;
    Label minLabel;
    Label maxLabel;
    Label windowLabel;
    Label levelLabel;
    boolean done;
    int autoThreshold;
    GridBagLayout gridbag;
    GridBagConstraints c;
    int y = 0;
    boolean windowLevel;
    boolean balance;
    Font monoFont = new Font("Monospaced", 0, 12);
    Font sanFont = new Font("SansSerif", 0, 12);
    int channels = 7;
    Choice choice;
    static final int RESET = 0;
    static final int AUTO = 1;
    static final int SET = 2;
    static final int APPLY = 3;
    static final int THRESHOLD = 4;
    static final int MIN = 5;
    static final int MAX = 6;
    static final int BRIGHTNESS = 7;
    static final int CONTRAST = 8;
    static final int UPDATE = 9;

    public ContrastAdjuster() {
        super("B&C");
    }

    public void run(String string) {
        this.windowLevel = string.equals("wl");
        this.balance = string.equals("balance");
        if (this.windowLevel) {
            this.setTitle("W&L");
        } else if (this.balance) {
            this.setTitle("Color");
            this.channels = 4;
        }
        if (instance != null) {
            if (!instance.getTitle().equals(this.getTitle())) {
                ContrastAdjuster contrastAdjuster = (ContrastAdjuster)instance;
                Prefs.saveLocation(LOC_KEY, contrastAdjuster.getLocation());
                contrastAdjuster.close();
            } else {
                instance.toFront();
                return;
            }
        }
        instance = this;
        IJ.register(ContrastAdjuster.class);
        WindowManager.addWindow(this);
        this.ij = IJ.getInstance();
        this.gridbag = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.setLayout(this.gridbag);
        this.c.gridx = 0;
        this.y = 0;
        this.c.gridy = this.y++;
        this.c.fill = 1;
        this.c.anchor = 10;
        this.c.insets = new Insets(10, 10, 0, 10);
        this.gridbag.setConstraints(this.plot, this.c);
        this.add(this.plot);
        this.plot.addKeyListener(this.ij);
        if (!this.windowLevel) {
            this.panel = new Panel();
            this.c.gridy = this.y++;
            this.c.insets = new Insets(0, 10, 0, 10);
            this.gridbag.setConstraints(this.panel, this.c);
            this.panel.setLayout(new BorderLayout());
            this.minLabel = new Label("      ", 0);
            this.minLabel.setFont(this.monoFont);
            this.panel.add("West", this.minLabel);
            this.maxLabel = new Label("      ", 2);
            this.maxLabel.setFont(this.monoFont);
            this.panel.add("East", this.maxLabel);
            this.add(this.panel);
        }
        if (!this.windowLevel) {
            this.minSlider = new Scrollbar(0, this.sliderRange / 2, 1, 0, this.sliderRange);
            this.c.gridy = this.y++;
            this.c.insets = new Insets(2, 10, 0, 10);
            this.gridbag.setConstraints(this.minSlider, this.c);
            this.add(this.minSlider);
            this.minSlider.addAdjustmentListener(this);
            this.minSlider.addKeyListener(this.ij);
            this.minSlider.setUnitIncrement(1);
            this.minSlider.setFocusable(false);
            this.addLabel("Minimum", null);
        }
        if (!this.windowLevel) {
            this.maxSlider = new Scrollbar(0, this.sliderRange / 2, 1, 0, this.sliderRange);
            this.c.gridy = this.y++;
            this.c.insets = new Insets(2, 10, 0, 10);
            this.gridbag.setConstraints(this.maxSlider, this.c);
            this.add(this.maxSlider);
            this.maxSlider.addAdjustmentListener(this);
            this.maxSlider.addKeyListener(this.ij);
            this.maxSlider.setUnitIncrement(1);
            this.maxSlider.setFocusable(false);
            this.addLabel("Maximum", null);
        }
        this.brightnessSlider = new Scrollbar(0, this.sliderRange / 2, 1, 0, this.sliderRange);
        this.c.gridy = this.y++;
        this.c.insets = new Insets(this.windowLevel ? 12 : 2, 10, 0, 10);
        this.gridbag.setConstraints(this.brightnessSlider, this.c);
        this.add(this.brightnessSlider);
        this.brightnessSlider.addAdjustmentListener(this);
        this.brightnessSlider.addKeyListener(this.ij);
        this.brightnessSlider.setUnitIncrement(1);
        this.brightnessSlider.setFocusable(false);
        if (this.windowLevel) {
            this.levelLabel = new TrimmedLabel("        ");
            this.addLabel("Level: ", this.levelLabel);
        } else {
            this.addLabel("Brightness", null);
        }
        if (!this.balance) {
            this.contrastSlider = new Scrollbar(0, this.sliderRange / 2, 1, 0, this.sliderRange);
            this.c.gridy = this.y++;
            this.c.insets = new Insets(2, 10, 0, 10);
            this.gridbag.setConstraints(this.contrastSlider, this.c);
            this.add(this.contrastSlider);
            this.contrastSlider.addAdjustmentListener(this);
            this.contrastSlider.addKeyListener(this.ij);
            this.contrastSlider.setUnitIncrement(1);
            this.contrastSlider.setFocusable(false);
            if (this.windowLevel) {
                this.windowLabel = new TrimmedLabel("        ");
                this.addLabel("Window: ", this.windowLabel);
            } else {
                this.addLabel("Contrast", null);
            }
        }
        if (this.balance) {
            this.c.gridy = this.y++;
            this.c.insets = new Insets(5, 10, 0, 10);
            this.choice = new Choice();
            this.addBalanceChoices();
            this.gridbag.setConstraints(this.choice, this.c);
            this.choice.addItemListener(this);
            this.add(this.choice);
        }
        int n = IJ.isMacOSX() ? 20 : 0;
        this.panel = new Panel();
        this.panel.setLayout(new GridLayout(0, 2, 0, 0));
        this.autoB = new TrimmedButton("Auto", n);
        this.autoB.addActionListener(this);
        this.autoB.addKeyListener(this.ij);
        this.panel.add(this.autoB);
        this.resetB = new TrimmedButton("Reset", n);
        this.resetB.addActionListener(this);
        this.resetB.addKeyListener(this.ij);
        this.panel.add(this.resetB);
        this.setB = new TrimmedButton("Set", n);
        this.setB.addActionListener(this);
        this.setB.addKeyListener(this.ij);
        this.panel.add(this.setB);
        this.applyB = new TrimmedButton("Apply", n);
        this.applyB.addActionListener(this);
        this.applyB.addKeyListener(this.ij);
        this.panel.add(this.applyB);
        this.c.gridy = this.y++;
        this.c.insets = new Insets(8, 5, 10, 5);
        this.gridbag.setConstraints(this.panel, this.c);
        this.add(this.panel);
        this.addKeyListener(this.ij);
        this.pack();
        Point point = Prefs.getLocation(LOC_KEY);
        if (point != null) {
            this.setLocation(point);
        } else {
            GUI.center(this);
        }
        if (IJ.isMacOSX()) {
            this.setResizable(false);
        }
        this.show();
        this.thread = new Thread((Runnable)this, "ContrastAdjuster");
        this.thread.start();
        this.setup();
    }

    void addBalanceChoices() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null && imagePlus.isComposite()) {
            for (int i = 0; i < altChannelLabels.length; ++i) {
                this.choice.addItem(altChannelLabels[i]);
            }
        } else {
            for (int i = 0; i < channelLabels.length; ++i) {
                this.choice.addItem(channelLabels[i]);
            }
        }
    }

    void addLabel(String string, Label label) {
        if (label == null && IJ.isMacOSX()) {
            string = string + "    ";
        }
        this.panel = new Panel();
        this.c.gridy = this.y++;
        int n = IJ.isMacOSX() ? 4 : 0;
        this.c.insets = new Insets(0, 10, n, 0);
        this.gridbag.setConstraints(this.panel, this.c);
        this.panel.setLayout(new FlowLayout(label == null ? 1 : 0, 0, 0));
        TrimmedLabel trimmedLabel = new TrimmedLabel(string);
        trimmedLabel.setFont(this.sanFont);
        this.panel.add(trimmedLabel);
        if (label != null) {
            label.setFont(this.monoFont);
            label.setAlignment(0);
            this.panel.add(label);
        }
        this.add(this.panel);
    }

    void setup() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null) {
            this.setup(imagePlus);
            this.updatePlot();
            this.updateLabels(imagePlus);
            imagePlus.updateAndDraw();
        }
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object object = adjustmentEvent.getSource();
        if (object == this.minSlider) {
            this.minSliderValue = this.minSlider.getValue();
        } else if (object == this.maxSlider) {
            this.maxSliderValue = this.maxSlider.getValue();
        } else if (object == this.contrastSlider) {
            this.contrastValue = this.contrastSlider.getValue();
        } else {
            this.brightnessValue = this.brightnessSlider.getValue();
        }
        this.notify();
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        Button button = (Button)actionEvent.getSource();
        if (button == null) {
            return;
        }
        if (button == this.resetB) {
            this.doReset = true;
        } else if (button == this.autoB) {
            this.doAutoAdjust = true;
        } else if (button == this.setB) {
            this.doSet = true;
        } else if (button == this.applyB) {
            this.doApplyLut = true;
        }
        this.notify();
    }

    ImageProcessor setup(ImagePlus imagePlus) {
        boolean bl;
        Roi roi = imagePlus.getRoi();
        if (roi != null) {
            roi.endPaste();
        }
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        int n = imagePlus.getType();
        int n2 = imagePlus.getCurrentSlice();
        this.RGBImage = n == 4;
        boolean bl2 = bl = this.RGBImage && this.previousSnapshot != null && ((ColorProcessor)imageProcessor).getSnapshotPixels() != this.previousSnapshot;
        if (imagePlus.getID() != this.previousImageID || bl || n != this.previousType || n2 != this.previousSlice) {
            this.setupNewImage(imagePlus, imageProcessor);
        }
        this.previousImageID = imagePlus.getID();
        this.previousType = n;
        this.previousSlice = n2;
        return imageProcessor;
    }

    void setupNewImage(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        this.previousMin = this.min;
        this.previousMax = this.max;
        if (this.RGBImage) {
            imageProcessor.snapshot();
            this.previousSnapshot = ((ColorProcessor)imageProcessor).getSnapshotPixels();
        } else {
            this.previousSnapshot = null;
        }
        double d = imagePlus.getDisplayRangeMin();
        double d2 = imagePlus.getDisplayRangeMax();
        if (imagePlus.getType() == 4) {
            d = 0.0;
            d2 = 255.0;
        }
        if (imageProcessor instanceof ShortProcessor || imageProcessor instanceof FloatProcessor) {
            imagePlus.resetDisplayRange();
            this.defaultMin = imagePlus.getDisplayRangeMin();
            this.defaultMax = imagePlus.getDisplayRangeMax();
        } else {
            this.defaultMin = 0.0;
            this.defaultMax = 255.0;
        }
        this.setMinAndMax(imagePlus, d, d2);
        this.min = imagePlus.getDisplayRangeMin();
        this.max = imagePlus.getDisplayRangeMax();
        if (IJ.debugMode) {
            IJ.log("min: " + this.min);
            IJ.log("max: " + this.max);
            IJ.log("defaultMin: " + this.defaultMin);
            IJ.log("defaultMax: " + this.defaultMax);
        }
        this.plot.defaultMin = this.defaultMin;
        this.plot.defaultMax = this.defaultMax;
        int n = (int)(this.defaultMax - this.defaultMin);
        int n2 = n;
        if (n2 > 640 && n2 < 1280) {
            n2 /= 2;
        } else if (n2 >= 1280) {
            n2 /= 5;
        }
        if (n2 < 256) {
            n2 = 256;
        }
        if (n2 > 1024) {
            n2 = 1024;
        }
        double d3 = this.max - this.min;
        if (n >= 1280 && n != 0 && d3 / (double)n < 0.25) {
            n2 = (int)((double)n2 * 1.6666);
        }
        if (n2 != this.sliderRange) {
            this.sliderRange = n2;
            this.updateScrollBars(null, true);
        } else {
            this.updateScrollBars(null, false);
        }
        if (this.balance) {
            if (imagePlus.isComposite()) {
                int n3 = imagePlus.getChannel();
                if (n3 <= 4) {
                    this.choice.select(n3 - 1);
                    this.channels = channelConstants[n3 - 1];
                }
                if (this.choice.getItem(0).equals("Red")) {
                    this.choice.removeAll();
                    this.addBalanceChoices();
                }
            } else if (this.choice.getItem(0).equals("Channel 1")) {
                this.choice.removeAll();
                this.addBalanceChoices();
            }
        }
        if (!this.doReset) {
            this.plotHistogram(imagePlus);
        }
        this.autoThreshold = 0;
        if (imagePlus.isComposite()) {
            IJ.setKeyUp(16);
        }
    }

    void setMinAndMax(ImagePlus imagePlus, double d, double d2) {
        if (this.channels != 7 && imagePlus.getType() == 4) {
            imagePlus.setDisplayRange(d, d2, this.channels);
        } else {
            imagePlus.setDisplayRange(d, d2);
        }
    }

    void updatePlot() {
        this.plot.min = this.min;
        this.plot.max = this.max;
        this.plot.repaint();
    }

    void updateLabels(ImagePlus imagePlus) {
        int n;
        boolean bl;
        double d = imagePlus.getDisplayRangeMin();
        double d2 = imagePlus.getDisplayRangeMax();
        int n2 = imagePlus.getType();
        Calibration calibration = imagePlus.getCalibration();
        boolean bl2 = bl = n2 == 2;
        if (calibration.calibrated()) {
            d = calibration.getCValue((int)d);
            d2 = calibration.getCValue((int)d2);
            if (n2 != 1) {
                bl = true;
            }
        }
        int n3 = n = bl ? 2 : 0;
        if (this.windowLevel) {
            double d3 = d2 - d;
            double d4 = d + d3 / 2.0;
            this.windowLabel.setText(IJ.d2s(d3, n));
            this.levelLabel.setText(IJ.d2s(d4, n));
        } else {
            this.minLabel.setText(IJ.d2s(d, n));
            this.maxLabel.setText(IJ.d2s(d2, n));
        }
    }

    void updateScrollBars(Scrollbar scrollbar, boolean bl) {
        double d;
        double d2;
        if (scrollbar == null || scrollbar != this.contrastSlider) {
            d2 = this.sliderRange / 2;
            d = (this.defaultMax - this.defaultMin) / (this.max - this.min) * d2;
            if (d > d2) {
                d = (double)this.sliderRange - (this.max - this.min) / (this.defaultMax - this.defaultMin) * d2;
            }
            this.contrast = (int)d;
            if (this.contrastSlider != null) {
                if (bl) {
                    this.contrastSlider.setValues(this.contrast, 1, 0, this.sliderRange);
                } else {
                    this.contrastSlider.setValue(this.contrast);
                }
            }
        }
        if (scrollbar == null || scrollbar != this.brightnessSlider) {
            d2 = this.min + (this.max - this.min) / 2.0;
            d = 1.0 - (d2 - this.defaultMin) / (this.defaultMax - this.defaultMin);
            this.brightness = (int)(d * (double)this.sliderRange);
            if (bl) {
                this.brightnessSlider.setValues(this.brightness, 1, 0, this.sliderRange);
            } else {
                this.brightnessSlider.setValue(this.brightness);
            }
        }
        if (this.minSlider != null && (scrollbar == null || scrollbar != this.minSlider)) {
            if (bl) {
                this.minSlider.setValues(this.scaleDown(this.min), 1, 0, this.sliderRange);
            } else {
                this.minSlider.setValue(this.scaleDown(this.min));
            }
        }
        if (this.maxSlider != null && (scrollbar == null || scrollbar != this.maxSlider)) {
            if (bl) {
                this.maxSlider.setValues(this.scaleDown(this.max), 1, 0, this.sliderRange);
            } else {
                this.maxSlider.setValue(this.scaleDown(this.max));
            }
        }
    }

    int scaleDown(double d) {
        if (d < this.defaultMin) {
            d = this.defaultMin;
        }
        if (d > this.defaultMax) {
            d = this.defaultMax;
        }
        return (int)((d - this.defaultMin) * ((double)this.sliderRange - 1.0) / (this.defaultMax - this.defaultMin));
    }

    void doMasking(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        ImageProcessor imageProcessor2 = imagePlus.getMask();
        if (imageProcessor2 != null) {
            imageProcessor.reset(imageProcessor2);
        }
    }

    void adjustMin(ImagePlus imagePlus, ImageProcessor imageProcessor, double d) {
        this.min = this.defaultMin + d * (this.defaultMax - this.defaultMin) / ((double)this.sliderRange - 1.0);
        if (this.max > this.defaultMax) {
            this.max = this.defaultMax;
        }
        if (this.min > this.max) {
            this.max = this.min;
        }
        this.setMinAndMax(imagePlus, this.min, this.max);
        if (this.min == this.max) {
            this.setThreshold(imageProcessor);
        }
        if (this.RGBImage) {
            this.doMasking(imagePlus, imageProcessor);
        }
        this.updateScrollBars(this.minSlider, false);
    }

    void adjustMax(ImagePlus imagePlus, ImageProcessor imageProcessor, double d) {
        this.max = this.defaultMin + d * (this.defaultMax - this.defaultMin) / ((double)this.sliderRange - 1.0);
        if (this.min < this.defaultMin) {
            this.min = this.defaultMin;
        }
        if (this.max < this.min) {
            this.min = this.max;
        }
        this.setMinAndMax(imagePlus, this.min, this.max);
        if (this.min == this.max) {
            this.setThreshold(imageProcessor);
        }
        if (this.RGBImage) {
            this.doMasking(imagePlus, imageProcessor);
        }
        this.updateScrollBars(this.maxSlider, false);
    }

    void adjustBrightness(ImagePlus imagePlus, ImageProcessor imageProcessor, double d) {
        double d2 = this.defaultMin + (this.defaultMax - this.defaultMin) * (((double)this.sliderRange - d) / (double)this.sliderRange);
        double d3 = this.max - this.min;
        this.min = d2 - d3 / 2.0;
        this.max = d2 + d3 / 2.0;
        this.setMinAndMax(imagePlus, this.min, this.max);
        if (this.min == this.max) {
            this.setThreshold(imageProcessor);
        }
        if (this.RGBImage) {
            this.doMasking(imagePlus, imageProcessor);
        }
        this.updateScrollBars(this.brightnessSlider, false);
    }

    void adjustContrast(ImagePlus imagePlus, ImageProcessor imageProcessor, int n) {
        double d = this.min + (this.max - this.min) / 2.0;
        double d2 = this.defaultMax - this.defaultMin;
        double d3 = this.sliderRange / 2;
        double d4 = (double)n <= d3 ? (double)n / d3 : d3 / (double)(this.sliderRange - n);
        if (d4 > 0.0) {
            this.min = d - 0.5 * d2 / d4;
            this.max = d + 0.5 * d2 / d4;
        }
        this.setMinAndMax(imagePlus, this.min, this.max);
        if (this.RGBImage) {
            this.doMasking(imagePlus, imageProcessor);
        }
        this.updateScrollBars(this.contrastSlider, false);
    }

    void reset(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        if (this.RGBImage) {
            imageProcessor.reset();
        }
        if (imageProcessor instanceof ShortProcessor || imageProcessor instanceof FloatProcessor) {
            imagePlus.resetDisplayRange();
            this.defaultMin = imagePlus.getDisplayRangeMin();
            this.defaultMax = imagePlus.getDisplayRangeMax();
            this.plot.defaultMin = this.defaultMin;
            this.plot.defaultMax = this.defaultMax;
        }
        this.min = this.defaultMin;
        this.max = this.defaultMax;
        this.setMinAndMax(imagePlus, this.min, this.max);
        this.updateScrollBars(null, false);
        this.plotHistogram(imagePlus);
        this.autoThreshold = 0;
    }

    void plotHistogram(ImagePlus imagePlus) {
        ImageStatistics imageStatistics;
        int n;
        if (this.balance && (this.channels == 4 || this.channels == 2 || this.channels == 1) && imagePlus.getType() == 4) {
            n = imagePlus.getWidth();
            int n2 = imagePlus.getHeight();
            byte[] byArray = new byte[n * n2];
            byte[] byArray2 = new byte[n * n2];
            byte[] byArray3 = new byte[n * n2];
            ((ColorProcessor)imagePlus.getProcessor()).getRGB(byArray, byArray2, byArray3);
            byte[] byArray4 = null;
            if (this.channels == 4) {
                byArray4 = byArray;
            } else if (this.channels == 2) {
                byArray4 = byArray2;
            } else if (this.channels == 1) {
                byArray4 = byArray3;
            }
            ByteProcessor byteProcessor = new ByteProcessor(n, n2, byArray4, null);
            imageStatistics = ImageStatistics.getStatistics(byteProcessor, 0, imagePlus.getCalibration());
        } else {
            int n3 = n = imagePlus.getType() == 1 ? ImagePlus.getDefault16bitRange() : 0;
            if (n != 0 && imagePlus.getProcessor().getMax() == Math.pow(2.0, n) - 1.0 && !imagePlus.getCalibration().isSigned16Bit()) {
                ImagePlus imagePlus2 = new ImagePlus("Temp", imagePlus.getProcessor());
                imageStatistics = new StackStatistics(imagePlus2, 256, 0.0, Math.pow(2.0, n));
            } else {
                imageStatistics = imagePlus.getStatistics();
            }
        }
        Color color = Color.gray;
        if (imagePlus.isComposite() && (!this.balance || this.channels != 7)) {
            color = ((CompositeImage)imagePlus).getChannelColor();
        }
        this.plot.setHistogram(imageStatistics, color);
    }

    void apply(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        String string = null;
        if (this.RGBImage) {
            imagePlus.unlock();
        }
        if (!imagePlus.lock()) {
            return;
        }
        if (this.RGBImage) {
            if (imagePlus.getStackSize() > 1) {
                this.applyRGBStack(imagePlus);
            } else {
                imageProcessor.snapshot();
                this.reset(imagePlus, imageProcessor);
                imagePlus.changes = true;
                if (Recorder.record) {
                    Recorder.record("run", "Apply LUT");
                }
            }
            imagePlus.unlock();
            return;
        }
        if (imagePlus.isComposite()) {
            imagePlus.unlock();
            ((CompositeImage)imagePlus).updateAllChannelsAndDraw();
            return;
        }
        if (imagePlus.getType() != 0) {
            IJ.beep();
            IJ.showStatus("Apply requires an 8-bit grayscale image or an RGB stack");
            imagePlus.unlock();
            return;
        }
        int[] nArray = new int[256];
        int n = (int)imagePlus.getDisplayRangeMin();
        int n2 = (int)imagePlus.getDisplayRangeMax();
        for (int i = 0; i < 256; ++i) {
            nArray[i] = i <= n ? 0 : (i >= n2 ? 255 : (int)((double)(i - n) / (double)(n2 - n) * 255.0));
        }
        imageProcessor.setRoi(imagePlus.getRoi());
        if (imagePlus.getStackSize() > 1) {
            ImageStack imageStack = imagePlus.getStack();
            YesNoCancelDialog yesNoCancelDialog = new YesNoCancelDialog((Frame)this, "Entire Stack?", "Apply LUT to all " + imageStack.getSize() + " slices in the stack?");
            if (yesNoCancelDialog.cancelPressed()) {
                imagePlus.unlock();
                return;
            }
            if (yesNoCancelDialog.yesPressed()) {
                int n3 = imagePlus.getCurrentSlice();
                ImageProcessor imageProcessor2 = imagePlus.getMask();
                for (int i = 1; i <= imagePlus.getStackSize(); ++i) {
                    imagePlus.setSlice(i);
                    imageProcessor = imagePlus.getProcessor();
                    if (imageProcessor2 != null) {
                        imageProcessor.snapshot();
                    }
                    imageProcessor.applyTable(nArray);
                    imageProcessor.reset(imageProcessor2);
                }
                imagePlus.setSlice(n3);
                string = "stack";
            } else {
                if (imageProcessor.getMask() != null) {
                    imageProcessor.snapshot();
                }
                imageProcessor.applyTable(nArray);
                imageProcessor.reset(imageProcessor.getMask());
                string = "slice";
            }
        } else {
            if (imageProcessor.getMask() != null) {
                imageProcessor.snapshot();
            }
            imageProcessor.applyTable(nArray);
            imageProcessor.reset(imageProcessor.getMask());
        }
        this.reset(imagePlus, imageProcessor);
        imagePlus.changes = true;
        imagePlus.unlock();
        if (Recorder.record) {
            if (string != null) {
                Recorder.record("run", "Apply LUT", string);
            } else {
                Recorder.record("run", "Apply LUT");
            }
        }
    }

    void applyRGBStack(ImagePlus imagePlus) {
        double d = imagePlus.getDisplayRangeMin();
        double d2 = imagePlus.getDisplayRangeMax();
        if (IJ.debugMode) {
            IJ.log("applyRGBStack: " + d + "-" + d2);
        }
        int n = imagePlus.getCurrentSlice();
        int n2 = imagePlus.getStackSize();
        if (!IJ.showMessageWithCancel("Update Entire Stack?", "Apply brightness and contrast settings\nto all " + n2 + " slices in the stack?\n \n" + "NOTE: There is no Undo for this operation.")) {
            return;
        }
        ImageProcessor imageProcessor = imagePlus.getMask();
        Rectangle rectangle = imagePlus.getRoi() != null ? imagePlus.getRoi().getBounds() : null;
        ImageStack imageStack = imagePlus.getStack();
        for (int i = 1; i <= n2; ++i) {
            IJ.showProgress(i, n2);
            IJ.showStatus(i + "/" + n2);
            if (i == n) continue;
            ImageProcessor imageProcessor2 = imageStack.getProcessor(i);
            imageProcessor2.setRoi(rectangle);
            if (imageProcessor != null) {
                imageProcessor2.snapshot();
            }
            if (this.channels != 7) {
                ((ColorProcessor)imageProcessor2).setMinAndMax(d, d2, this.channels);
            } else {
                imageProcessor2.setMinAndMax(d, d2);
            }
            if (imageProcessor == null) continue;
            imageProcessor2.reset(imageProcessor);
        }
        imagePlus.setStack(null, imageStack);
        imagePlus.setSlice(n);
        imagePlus.changes = true;
        if (Recorder.record) {
            Recorder.record("run", "Apply LUT", "stack");
        }
    }

    void setThreshold(ImageProcessor imageProcessor) {
        if (!(imageProcessor instanceof ByteProcessor)) {
            return;
        }
        if (((ByteProcessor)imageProcessor).isInvertedLut()) {
            imageProcessor.setThreshold(this.max, 255.0, 2);
        } else {
            imageProcessor.setThreshold(0.0, this.max, 2);
        }
    }

    void autoAdjust(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        int n;
        if (this.RGBImage) {
            imageProcessor.reset();
        }
        Calibration calibration = imagePlus.getCalibration();
        imagePlus.setCalibration(null);
        ImageStatistics imageStatistics = imagePlus.getStatistics();
        imagePlus.setCalibration(calibration);
        int n2 = imageStatistics.pixelCount / 10;
        int[] nArray = imageStatistics.histogram;
        this.autoThreshold = this.autoThreshold < 10 ? 5000 : (this.autoThreshold /= 2);
        int n3 = imageStatistics.pixelCount / this.autoThreshold;
        int n4 = -1;
        boolean bl = false;
        do {
            if ((n = nArray[++n4]) > n2) {
                n = 0;
            }
            boolean bl2 = bl = n > n3;
        } while (!bl && n4 < 255);
        int n5 = n4;
        n4 = 256;
        do {
            if ((n = nArray[--n4]) > n2) {
                n = 0;
            }
            boolean bl3 = bl = n > n3;
        } while (!bl && n4 > 0);
        int n6 = n4;
        Roi roi = imagePlus.getRoi();
        if (n6 >= n5) {
            if (this.RGBImage) {
                imagePlus.killRoi();
            }
            this.min = imageStatistics.histMin + (double)n5 * imageStatistics.binSize;
            this.max = imageStatistics.histMin + (double)n6 * imageStatistics.binSize;
            if (this.min == this.max) {
                this.min = imageStatistics.min;
                this.max = imageStatistics.max;
            }
            this.setMinAndMax(imagePlus, this.min, this.max);
            if (this.RGBImage && roi != null) {
                imagePlus.setRoi(roi);
            }
        } else {
            this.reset(imagePlus, imageProcessor);
            return;
        }
        this.updateScrollBars(null, false);
        if (Recorder.record) {
            Recorder.record("run", "Enhance Contrast", "saturated=0.35");
        }
    }

    void setMinAndMax(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        boolean bl;
        int n;
        this.min = imagePlus.getDisplayRangeMin();
        this.max = imagePlus.getDisplayRangeMax();
        Calibration calibration = imagePlus.getCalibration();
        int n2 = imageProcessor instanceof FloatProcessor || calibration.calibrated() ? 2 : 0;
        double d = calibration.getCValue(this.min);
        double d2 = calibration.getCValue(this.max);
        int n3 = imagePlus.getNChannels();
        GenericDialog genericDialog = new GenericDialog("Set Display Range");
        genericDialog.addNumericField("Minimum displayed value: ", d, n2);
        genericDialog.addNumericField("Maximum displayed value: ", d2, n2);
        genericDialog.addChoice("Unsigned 16-bit range:", ranges, ranges[this.getRangeIndex()]);
        genericDialog.addCheckbox("Propagate to all open images", false);
        if (imagePlus.isComposite()) {
            genericDialog.addCheckbox("Propagate to all " + n3 + " channels", false);
        }
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        d = genericDialog.getNextNumber();
        d2 = genericDialog.getNextNumber();
        d = calibration.getRawValue(d);
        d2 = calibration.getRawValue(d2);
        int n4 = genericDialog.getNextChoiceIndex();
        int n5 = ImagePlus.getDefault16bitRange();
        if (n5 != (n = this.setRange(n4)) && imagePlus.getType() == 1 && !calibration.isSigned16Bit()) {
            this.reset(imagePlus, imageProcessor);
            d = imagePlus.getDisplayRangeMin();
            d2 = imagePlus.getDisplayRangeMax();
        }
        boolean bl2 = genericDialog.getNextBoolean();
        boolean bl3 = bl = imagePlus.isComposite() && genericDialog.getNextBoolean();
        if (d2 >= d) {
            int n6;
            int n7;
            this.min = d;
            this.max = d2;
            this.setMinAndMax(imagePlus, this.min, this.max);
            this.updateScrollBars(null, false);
            if (this.RGBImage) {
                this.doMasking(imagePlus, imageProcessor);
            }
            if (bl2) {
                IJ.runMacroFile("ij.jar:PropagateMinAndMax");
            }
            if (bl) {
                n7 = imagePlus.getChannel();
                for (n6 = 1; n6 <= n3; ++n6) {
                    imagePlus.setPositionWithoutUpdate(n6, imagePlus.getSlice(), imagePlus.getFrame());
                    imagePlus.setDisplayRange(this.min, this.max);
                }
                ((CompositeImage)imagePlus).reset();
                imagePlus.setPosition(n7, imagePlus.getSlice(), imagePlus.getFrame());
            }
            if (Recorder.record) {
                if (imagePlus.getBitDepth() == 32) {
                    Recorder.record("setMinAndMax", this.min, this.max);
                } else {
                    n7 = (int)this.min;
                    n6 = (int)this.max;
                    if (calibration.isSigned16Bit()) {
                        n7 = (int)calibration.getCValue(n7);
                        n6 = (int)calibration.getCValue(n6);
                    }
                    Recorder.record("setMinAndMax", n7, n6);
                }
                if (Recorder.scriptMode()) {
                    Recorder.recordCall("ImagePlus.setDefault16bitRange(" + n + ");");
                } else {
                    Recorder.recordString("call(\"ij.ImagePlus.setDefault16bitRange\", " + n + ");\n");
                }
            }
        }
    }

    int getRangeIndex() {
        int n = ImagePlus.getDefault16bitRange();
        int n2 = 0;
        if (n == 8) {
            n2 = 1;
        } else if (n == 10) {
            n2 = 2;
        } else if (n == 12) {
            n2 = 3;
        } else if (n == 15) {
            n2 = 4;
        } else if (n == 16) {
            n2 = 5;
        }
        return n2;
    }

    int setRange(int n) {
        int n2 = 0;
        if (n == 1) {
            n2 = 8;
        } else if (n == 2) {
            n2 = 10;
        } else if (n == 3) {
            n2 = 12;
        } else if (n == 4) {
            n2 = 15;
        } else if (n == 5) {
            n2 = 16;
        }
        ImagePlus.setDefault16bitRange(n2);
        return n2;
    }

    void setWindowLevel(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        this.min = imagePlus.getDisplayRangeMin();
        this.max = imagePlus.getDisplayRangeMax();
        Calibration calibration = imagePlus.getCalibration();
        int n = imageProcessor instanceof FloatProcessor || calibration.calibrated() ? 2 : 0;
        double d = calibration.getCValue(this.min);
        double d2 = calibration.getCValue(this.max);
        double d3 = d2 - d;
        double d4 = d + d3 / 2.0;
        GenericDialog genericDialog = new GenericDialog("Set W&L");
        genericDialog.addNumericField("Window Center (Level): ", d4, n);
        genericDialog.addNumericField("Window Width: ", d3, n);
        genericDialog.addCheckbox("Propagate to all open images", false);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        d4 = genericDialog.getNextNumber();
        d3 = genericDialog.getNextNumber();
        d = d4 - d3 / 2.0;
        d2 = d4 + d3 / 2.0;
        d = calibration.getRawValue(d);
        d2 = calibration.getRawValue(d2);
        boolean bl = genericDialog.getNextBoolean();
        if (d2 >= d) {
            this.min = d;
            this.max = d2;
            this.setMinAndMax(imagePlus, d, d2);
            this.updateScrollBars(null, false);
            if (this.RGBImage) {
                this.doMasking(imagePlus, imageProcessor);
            }
            if (bl) {
                IJ.runMacroFile("ij.jar:PropagateMinAndMax");
            }
            if (Recorder.record) {
                if (imagePlus.getBitDepth() == 32) {
                    Recorder.record("setMinAndMax", this.min, this.max);
                } else {
                    int n2 = (int)this.min;
                    int n3 = (int)this.max;
                    if (calibration.isSigned16Bit()) {
                        n2 = (int)calibration.getCValue(n2);
                        n3 = (int)calibration.getCValue(n3);
                    }
                    Recorder.record("setMinAndMax", n2, n3);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.done) {
            ContrastAdjuster contrastAdjuster = this;
            synchronized (contrastAdjuster) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.doUpdate();
        }
    }

    void doUpdate() {
        int n;
        int n2 = this.minSliderValue;
        int n3 = this.maxSliderValue;
        int n4 = this.brightnessValue;
        int n5 = this.contrastValue;
        if (this.doReset) {
            n = 0;
        } else if (this.doAutoAdjust) {
            n = 1;
        } else if (this.doSet) {
            n = 2;
        } else if (this.doApplyLut) {
            n = 3;
        } else if (this.minSliderValue >= 0) {
            n = 5;
        } else if (this.maxSliderValue >= 0) {
            n = 6;
        } else if (this.brightnessValue >= 0) {
            n = 7;
        } else if (this.contrastValue >= 0) {
            n = 8;
        } else {
            return;
        }
        this.contrastValue = -1;
        this.brightnessValue = -1;
        this.maxSliderValue = -1;
        this.minSliderValue = -1;
        this.doApplyLut = false;
        this.doSet = false;
        this.doAutoAdjust = false;
        this.doReset = false;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.beep();
            IJ.showStatus("No image");
            return;
        }
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        if (this.RGBImage && !imagePlus.lock()) {
            imagePlus = null;
            return;
        }
        switch (n) {
            case 0: {
                this.reset(imagePlus, imageProcessor);
                if (!Recorder.record) break;
                Recorder.record("resetMinAndMax");
                break;
            }
            case 1: {
                this.autoAdjust(imagePlus, imageProcessor);
                break;
            }
            case 2: {
                if (this.windowLevel) {
                    this.setWindowLevel(imagePlus, imageProcessor);
                    break;
                }
                this.setMinAndMax(imagePlus, imageProcessor);
                break;
            }
            case 3: {
                this.apply(imagePlus, imageProcessor);
                break;
            }
            case 5: {
                this.adjustMin(imagePlus, imageProcessor, n2);
                break;
            }
            case 6: {
                this.adjustMax(imagePlus, imageProcessor, n3);
                break;
            }
            case 7: {
                this.adjustBrightness(imagePlus, imageProcessor, n4);
                break;
            }
            case 8: {
                this.adjustContrast(imagePlus, imageProcessor, n5);
            }
        }
        this.updatePlot();
        this.updateLabels(imagePlus);
        if ((IJ.shiftKeyDown() || this.balance && this.channels == 7) && imagePlus.isComposite()) {
            ((CompositeImage)imagePlus).updateAllChannelsAndDraw();
        } else {
            imagePlus.updateChannelAndDraw();
        }
        if (this.RGBImage) {
            imagePlus.unlock();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.close();
        Prefs.saveLocation(LOC_KEY, this.getLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        instance = null;
        this.done = true;
        ContrastAdjuster contrastAdjuster = this;
        synchronized (contrastAdjuster) {
            this.notify();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
        super.windowActivated(windowEvent);
        this.previousImageID = 0;
        this.setup();
        WindowManager.setWindow(this);
    }

    public synchronized void itemStateChanged(ItemEvent itemEvent) {
        int n = this.choice.getSelectedIndex();
        this.channels = channelConstants[n];
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null && imagePlus.isComposite()) {
            if (n + 1 <= imagePlus.getNChannels()) {
                imagePlus.setPosition(n + 1, imagePlus.getSlice(), imagePlus.getFrame());
            } else {
                this.choice.select(channelLabels.length - 1);
                this.channels = 7;
            }
        } else {
            this.doReset = true;
        }
        this.notify();
    }

    public void updateAndDraw() {
        this.previousImageID = 0;
        this.toFront();
    }

    public static void update() {
        if (instance != null) {
            ContrastAdjuster contrastAdjuster = (ContrastAdjuster)instance;
            contrastAdjuster.previousImageID = 0;
            contrastAdjuster.setup();
        }
    }
}

