/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;

public class Translator
implements ExtendedPlugInFilter,
DialogListener {
    private int flags = 32799;
    private static double xOffset = 15.0;
    private static double yOffset = 15.0;
    private ImagePlus imp;
    private GenericDialog gd;
    private PlugInFilterRunner pfr;
    private static int interpolationMethod = 0;
    private String[] methods = ImageProcessor.getInterpolationMethods();

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return this.flags;
    }

    public void run(ImageProcessor imageProcessor) {
        imageProcessor.setInterpolationMethod(interpolationMethod);
        imageProcessor.translate(xOffset, yOffset);
    }

    public int showDialog(ImagePlus imagePlus, String string, PlugInFilterRunner plugInFilterRunner) {
        this.pfr = plugInFilterRunner;
        int n = xOffset == (double)((int)xOffset) && yOffset == (double)((int)yOffset) ? 1 : 3;
        this.gd = new GenericDialog("Translate");
        this.gd.addNumericField("X Offset (pixels): ", xOffset, n, 8, "");
        this.gd.addNumericField("Y Offset (pixels): ", yOffset, n, 8, "");
        this.gd.addChoice("Interpolation:", this.methods, this.methods[interpolationMethod]);
        this.gd.addPreviewCheckbox(plugInFilterRunner);
        this.gd.addDialogListener(this);
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            return 4096;
        }
        return IJ.setupDialog(imagePlus, this.flags);
    }

    public boolean dialogItemChanged(GenericDialog genericDialog, AWTEvent aWTEvent) {
        xOffset = genericDialog.getNextNumber();
        yOffset = genericDialog.getNextNumber();
        interpolationMethod = genericDialog.getNextChoiceIndex();
        if (genericDialog.invalidNumber()) {
            if (genericDialog.wasOKed()) {
                IJ.error("Offset is invalid.");
            }
            return false;
        }
        return true;
    }

    public void setNPasses(int n) {
    }
}

