/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.plugin.ImagesToStack;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.awt.image.ColorModel;

public class StackEditor
implements PlugIn {
    ImagePlus imp;
    int nSlices;
    int width;
    int height;
    static boolean deleteFrames;

    public void run(String string) {
        this.imp = IJ.getImage();
        this.nSlices = this.imp.getStackSize();
        this.width = this.imp.getWidth();
        this.height = this.imp.getHeight();
        if (string.equals("add")) {
            this.addSlice();
        } else if (string.equals("delete")) {
            this.deleteSlice();
        } else if (string.equals("toimages")) {
            this.convertStackToImages(this.imp);
        }
    }

    void addSlice() {
        Object object;
        if (this.imp.isDisplayedHyperStack()) {
            return;
        }
        if (!this.imp.lock()) {
            return;
        }
        int n = 0;
        ImageStack imageStack = this.imp.getStack();
        if (imageStack.getSize() == 1) {
            Object object2;
            object = imageStack.getSliceLabel(1);
            if (object != null && ((String)object).indexOf("\n") != -1) {
                imageStack.setSliceLabel(null, 1);
            }
            if ((object2 = this.imp.getProperty("Label")) != null && object2 instanceof String) {
                imageStack.setSliceLabel((String)object2, 1);
            }
            n = this.imp.getID();
        }
        object = this.imp.getProcessor();
        int n2 = this.imp.getCurrentSlice();
        if (IJ.altKeyDown()) {
            --n2;
        }
        imageStack.addSlice(null, ((ImageProcessor)object).createProcessor(this.width, this.height), n2);
        this.imp.setStack(null, imageStack);
        this.imp.setSlice(n2 + 1);
        this.imp.unlock();
        if (n != 0) {
            IJ.selectWindow(n);
        }
    }

    void deleteSlice() {
        String string;
        if (this.nSlices < 2) {
            IJ.error("\"Delete Slice\" requires a stack");
            return;
        }
        if (this.imp.isDisplayedHyperStack()) {
            this.deleteHyperstackSliceOrFrame();
            return;
        }
        if (!this.imp.lock()) {
            return;
        }
        ImageStack imageStack = this.imp.getStack();
        int n = this.imp.getCurrentSlice();
        imageStack.deleteSlice(n);
        if (imageStack.getSize() == 1 && (string = imageStack.getSliceLabel(1)) != null) {
            this.imp.setProperty("Label", string);
        }
        this.imp.setStack(null, imageStack);
        if (n-- < 1) {
            n = 1;
        }
        this.imp.setSlice(n);
        this.imp.unlock();
    }

    void deleteHyperstackSliceOrFrame() {
        Object object;
        int n = this.imp.getNChannels();
        int n2 = this.imp.getNSlices();
        int n3 = this.imp.getNFrames();
        int n4 = this.imp.getChannel();
        int n5 = this.imp.getSlice();
        int n6 = this.imp.getFrame();
        if (n3 > 1 && n2 == 1) {
            deleteFrames = true;
        } else if (n3 == 1 && n2 > 1) {
            deleteFrames = false;
        } else if (n2 > 1 && n3 > 1) {
            object = new GenericDialog("Delete Slice");
            ((GenericDialog)object).addCheckbox("Delete time point " + n6, deleteFrames);
            ((GenericDialog)object).showDialog();
            if (((GenericDialog)object).wasCanceled()) {
                return;
            }
            deleteFrames = ((GenericDialog)object).getNextBoolean();
        } else {
            return;
        }
        if (!this.imp.lock()) {
            return;
        }
        object = this.imp.getStack();
        if (deleteFrames) {
            for (int i = n2; i >= 1; --i) {
                int n7 = this.imp.getStackIndex(n, i, n6);
                for (int j = 0; j < n; ++j) {
                    ((ImageStack)object).deleteSlice(n7 - j);
                }
            }
            --n3;
        } else {
            for (int i = n3; i >= 1; --i) {
                int n8 = this.imp.getStackIndex(n, n5, i);
                for (int j = 0; j < n; ++j) {
                    ((ImageStack)object).deleteSlice(n8 - j);
                }
            }
            --n2;
        }
        this.imp.setDimensions(n, n2, n3);
        this.imp.unlock();
    }

    public void convertImagesToStack() {
        new ImagesToStack().run("");
    }

    public void convertStackToImages(ImagePlus imagePlus) {
        CompositeImage compositeImage;
        boolean bl;
        if (this.nSlices < 2) {
            IJ.error("\"Convert Stack to Images\" requires a stack");
            return;
        }
        if (!imagePlus.lock()) {
            return;
        }
        ImageStack imageStack = imagePlus.getStack();
        int n = imageStack.getSize();
        if (n > 30 && !IJ.isMacro() && !(bl = IJ.showMessageWithCancel("Convert to Images?", "Are you sure you want to convert this\nstack to " + n + " separate windows?"))) {
            imagePlus.unlock();
            return;
        }
        Calibration calibration = imagePlus.getCalibration();
        CompositeImage compositeImage2 = compositeImage = imagePlus.isComposite() ? (CompositeImage)imagePlus : null;
        if (imagePlus.getNChannels() != imagePlus.getStackSize()) {
            compositeImage = null;
        }
        for (int i = 1; i <= n; ++i) {
            Object object;
            String string = imageStack.getShortSliceLabel(i);
            String string2 = string != null && !string.equals("") ? string : this.getTitle(imagePlus, i);
            ImageProcessor imageProcessor = imageStack.getProcessor(i);
            if (compositeImage != null && (object = compositeImage.getChannelLut(i)) != null) {
                imageProcessor.setColorModel((ColorModel)object);
                imageProcessor.setMinAndMax(((LUT)object).min, ((LUT)object).max);
            }
            object = new ImagePlus(string2, imageProcessor);
            ((ImagePlus)object).setCalibration(calibration);
            String string3 = imageStack.getSliceLabel(i);
            if (string3 != null && !string3.equals(string)) {
                ((ImagePlus)object).setProperty("Info", string3);
            }
            ((ImagePlus)object).show();
        }
        imagePlus.changes = false;
        ImageWindow imageWindow = imagePlus.getWindow();
        if (imageWindow != null) {
            imageWindow.close();
        } else if (Interpreter.isBatchMode()) {
            Interpreter.removeBatchModeImage(imagePlus);
        }
        imagePlus.unlock();
    }

    String getTitle(ImagePlus imagePlus, int n) {
        String string = "00000000" + n;
        return imagePlus.getShortTitle() + "-" + string.substring(string.length() - 4, string.length());
    }
}

