/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;

public class MontageMaker
implements PlugIn {
    private static int columns;
    private static int rows;
    private static int first;
    private static int last;
    private static int inc;
    private static int borderWidth;
    private static double scale;
    private static boolean label;
    private static boolean useForegroundColor;
    private static int saveID;
    private static int saveStackSize;
    private static int fontSize;

    public void run(String string) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null || imagePlus.getStackSize() == 1) {
            IJ.error("Stack required");
            return;
        }
        if (imagePlus.isHyperStack()) {
            IJ.error("Make Montage", "Make Montage does not work directly with hyperstacks. You need\nto first use the Image>Type>RGB Color command to create a Z or T\nseries, or use Image>Hyperstacks>Reduce Dimensionality to create\na stack that can be used to create a channel montage.");
            return;
        }
        int n = imagePlus.getNChannels();
        if (imagePlus.isComposite() && n > 1) {
            int n2 = imagePlus.getChannel();
            CompositeImage compositeImage = (CompositeImage)imagePlus;
            int n3 = compositeImage.getMode();
            if (n3 == 1) {
                compositeImage.setMode(2);
            }
            ImageStack imageStack = new ImageStack(imagePlus.getWidth(), imagePlus.getHeight());
            for (int i = 1; i <= n; ++i) {
                imagePlus.setPositionWithoutUpdate(i, imagePlus.getSlice(), imagePlus.getFrame());
                Image image = imagePlus.getImage();
                imageStack.addSlice(null, new ColorProcessor(image));
            }
            if (compositeImage.getMode() != n3) {
                compositeImage.setMode(n3);
            }
            imagePlus.setPosition(n2, imagePlus.getSlice(), imagePlus.getFrame());
            imagePlus = new ImagePlus(imagePlus.getTitle(), imageStack);
        }
        this.makeMontage(imagePlus);
        imagePlus.updateImage();
        saveID = imagePlus.getID();
        IJ.register(MontageMaker.class);
    }

    public void makeMontage(ImagePlus imagePlus) {
        int n = imagePlus.getStackSize();
        if (columns == 0 || imagePlus.getID() != saveID && n != saveStackSize) {
            rows = columns = (int)Math.sqrt(n);
            int n2 = n - columns * rows;
            if (n2 > 0) {
                columns += (int)Math.ceil((double)n2 / (double)rows);
            }
            scale = 1.0;
            if (imagePlus.getWidth() * columns > 800) {
                scale = 0.5;
            }
            if (imagePlus.getWidth() * columns > 1600) {
                scale = 0.25;
            }
            inc = 1;
            first = 1;
            last = n;
        }
        saveStackSize = n;
        GenericDialog genericDialog = new GenericDialog("Make Montage", IJ.getInstance());
        genericDialog.addNumericField("Columns:", columns, 0);
        genericDialog.addNumericField("Rows:", rows, 0);
        genericDialog.addNumericField("Scale Factor:", scale, 2);
        genericDialog.addNumericField("First Slice:", first, 0);
        genericDialog.addNumericField("Last Slice:", last, 0);
        genericDialog.addNumericField("Increment:", inc, 0);
        genericDialog.addNumericField("Border Width:", borderWidth, 0);
        genericDialog.addNumericField("Font Size:", fontSize, 0);
        genericDialog.addCheckbox("Label Slices", label);
        genericDialog.addCheckbox("Use Foreground Color", useForegroundColor);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        columns = (int)genericDialog.getNextNumber();
        rows = (int)genericDialog.getNextNumber();
        scale = genericDialog.getNextNumber();
        first = (int)genericDialog.getNextNumber();
        last = (int)genericDialog.getNextNumber();
        inc = (int)genericDialog.getNextNumber();
        borderWidth = (int)genericDialog.getNextNumber();
        fontSize = (int)genericDialog.getNextNumber();
        if (borderWidth < 0) {
            borderWidth = 0;
        }
        if (first < 1) {
            first = 1;
        }
        if (last > n) {
            last = n;
        }
        if (first > last) {
            first = 1;
            last = n;
        }
        if (inc < 1) {
            inc = 1;
        }
        if (genericDialog.invalidNumber()) {
            IJ.error("Invalid number");
            return;
        }
        label = genericDialog.getNextBoolean();
        useForegroundColor = genericDialog.getNextBoolean();
        ImagePlus imagePlus2 = this.makeMontage2(imagePlus, columns, rows, scale, first, last, inc, borderWidth, label);
        imagePlus2.show();
    }

    public void makeMontage(ImagePlus imagePlus, int n, int n2, double d, int n3, int n4, int n5, int n6, boolean bl) {
        ImagePlus imagePlus2 = this.makeMontage2(imagePlus, n, n2, d, n3, n4, n5, n6, bl);
        imagePlus2.show();
    }

    public ImagePlus makeMontage2(ImagePlus imagePlus, int n, int n2, double d, int n3, int n4, int n5, int n6, boolean bl) {
        Object object;
        Object object2;
        int n7 = imagePlus.getWidth();
        int n8 = imagePlus.getHeight();
        int n9 = imagePlus.getStackSize();
        int n10 = (int)((double)n7 * d);
        int n11 = (int)((double)n8 * d);
        int n12 = n10 * n;
        int n13 = n11 * n2;
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        ImageProcessor imageProcessor2 = imageProcessor.createProcessor(n12 + n6 / 2, n13 + n6 / 2);
        Color color = Color.white;
        Color color2 = Color.black;
        if (useForegroundColor) {
            color = Toolbar.getForegroundColor();
            color2 = Toolbar.getBackgroundColor();
        } else {
            boolean bl2 = false;
            if (imageProcessor instanceof ByteProcessor || imageProcessor instanceof ColorProcessor) {
                imageProcessor.setRoi(0, n8 - 12, n7, 12);
                object2 = ImageStatistics.getStatistics(imageProcessor, 8, null);
                imageProcessor.resetRoi();
                boolean bl3 = bl2 = ((ImageStatistics)object2).mode >= 200;
                if (imagePlus.isInvertedLut()) {
                    boolean bl4 = bl2 = !bl2;
                }
            }
            if (bl2) {
                color = Color.black;
                color2 = Color.white;
            }
        }
        imageProcessor2.setColor(color2);
        imageProcessor2.fill();
        imageProcessor2.setColor(color);
        Dimension dimension = IJ.getScreenSize();
        imageProcessor2.setFont(new Font("SansSerif", 0, fontSize));
        imageProcessor2.setAntialiasedText(true);
        object2 = imagePlus.getStack();
        int n14 = 0;
        int n15 = 0;
        for (int i = n3; i <= n4; i += n5) {
            ImageProcessor imageProcessor3 = ((ImageStack)object2).getProcessor(i);
            if (d != 1.0) {
                imageProcessor3 = imageProcessor3.resize(n10, n11);
            }
            imageProcessor2.insert(imageProcessor3, n14, n15);
            object = ((ImageStack)object2).getShortSliceLabel(i);
            if (n6 > 0) {
                this.drawBorder(imageProcessor2, n14, n15, n10, n11, n6);
            }
            if (bl) {
                this.drawLabel(imageProcessor2, i, (String)object, n14, n15, n10, n11);
            }
            if ((n14 += n10) >= n12) {
                n14 = 0;
                if ((n15 += n11) >= n13) break;
            }
            IJ.showProgress((double)(i - n3) / (double)(n4 - n3));
        }
        if (n6 > 0) {
            int n16 = n6 / 2;
            this.drawBorder(imageProcessor2, n16, n16, n12 - n16, n13 - n16, n6);
        }
        IJ.showProgress(1.0);
        object = new ImagePlus("Montage", imageProcessor2);
        ((ImagePlus)object).setCalibration(imagePlus.getCalibration());
        Calibration calibration = ((ImagePlus)object).getCalibration();
        if (calibration.scaled()) {
            calibration.pixelWidth /= d;
            calibration.pixelHeight /= d;
        }
        ((ImagePlus)object).setProperty("Info", "xMontage=" + n + "\nyMontage=" + n2 + "\n");
        return object;
    }

    void drawBorder(ImageProcessor imageProcessor, int n, int n2, int n3, int n4, int n5) {
        imageProcessor.setLineWidth(n5);
        imageProcessor.moveTo(n, n2);
        imageProcessor.lineTo(n + n3, n2);
        imageProcessor.lineTo(n + n3, n2 + n4);
        imageProcessor.lineTo(n, n2 + n4);
        imageProcessor.lineTo(n, n2);
    }

    void drawLabel(ImageProcessor imageProcessor, int n, String string, int n2, int n3, int n4, int n5) {
        if (string != null && !string.equals("") && imageProcessor.getStringWidth(string) >= n4) {
            while ((string = string.substring(0, string.length() - 1)).length() > 1 && imageProcessor.getStringWidth(string) >= n4) {
            }
        }
        if (string == null || string.equals("")) {
            string = "" + n;
        }
        int n6 = imageProcessor.getStringWidth(string);
        imageProcessor.drawString(string, n2 += n4 / 2 - n6 / 2, n3 += n5);
    }

    static {
        fontSize = 12;
    }
}

