/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Prefs;
import ij.WindowManager;
import ij.io.SaveDialog;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import ij.text.TextPanel;
import ij.text.TextWindow;
import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public class MeasurementsWriter
implements PlugIn {
    public void run(String string) {
        this.save(string);
    }

    public boolean save(String string) {
        Frame frame = WindowManager.getFrontWindow();
        if (frame != null && frame instanceof TextWindow) {
            TextWindow textWindow = (TextWindow)frame;
            if (textWindow.getTextPanel().getResultsTable() == null) {
                IJ.error("Save As>Results", "\"" + textWindow.getTitle() + "\" is not a results table");
                return false;
            }
            return textWindow.getTextPanel().saveAs(string);
        }
        if (IJ.isResultsWindow()) {
            TextPanel textPanel = IJ.getTextPanel();
            if (textPanel != null && !textPanel.saveAs(string)) {
                return false;
            }
        } else {
            Object object;
            Object object2;
            ResultsTable resultsTable = ResultsTable.getResultsTable();
            if (resultsTable == null || resultsTable.getCounter() == 0) {
                return false;
            }
            if (string.equals("")) {
                object2 = new SaveDialog("Save as Text", "Results", Prefs.get("options.ext", ".xls"));
                object = ((SaveDialog)object2).getFileName();
                if (object == null) {
                    return false;
                }
                string = ((SaveDialog)object2).getDirectory() + (String)object;
            }
            object2 = null;
            try {
                object = new FileOutputStream(string);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)object);
                object2 = new PrintWriter(bufferedOutputStream);
            }
            catch (IOException iOException) {
                IJ.log("MeasurementsWriter: " + iOException);
                return false;
            }
            int n = resultsTable.getCounter();
            for (int i = 0; i < n; ++i) {
                ((PrintWriter)object2).println(resultsTable.getRowAsString(i));
            }
            ((PrintWriter)object2).close();
        }
        return true;
    }
}

