/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.IJ;
import ij.macro.Interpreter;
import ij.macro.MacroConstants;
import ij.macro.Symbol;
import ij.macro.Variable;
import java.util.Hashtable;

public class Program
implements MacroConstants {
    private int maxSymbols = 800;
    private int maxProgramSize = 2000;
    private int pc = -1;
    int stLoc = -1;
    int symTabLoc;
    Symbol[] table = new Symbol[this.maxSymbols];
    static Symbol[] systemTable;
    int[] code = new int[this.maxProgramSize];
    int[] lineNumbers = new int[this.maxProgramSize];
    Variable[] globals;
    boolean hasVars;
    boolean hasFunctions;
    int macroCount;
    Hashtable menus;
    boolean queueCommands;
    Hashtable extensionRegistry;

    public Program() {
        if (systemTable != null) {
            this.stLoc = systemTable.length - 1;
            for (int i = 0; i <= this.stLoc; ++i) {
                this.table[i] = systemTable[i];
            }
        } else {
            this.addKeywords();
            this.addFunctions();
            this.addNumericFunctions();
            this.addStringFunctions();
            this.addArrayFunctions();
            systemTable = new Symbol[this.stLoc + 1];
            for (int i = 0; i <= this.stLoc; ++i) {
                Program.systemTable[i] = this.table[i];
            }
            IJ.register(Program.class);
        }
    }

    public int[] getCode() {
        return this.code;
    }

    public Symbol[] getSymbolTable() {
        return this.table;
    }

    void addKeywords() {
        for (int i = 0; i < keywords.length; ++i) {
            this.addSymbol(new Symbol(keywordIDs[i], keywords[i]));
        }
    }

    void addFunctions() {
        for (int i = 0; i < functions.length; ++i) {
            this.addSymbol(new Symbol(functionIDs[i], functions[i]));
        }
    }

    void addNumericFunctions() {
        for (int i = 0; i < numericFunctions.length; ++i) {
            this.addSymbol(new Symbol(numericFunctionIDs[i], numericFunctions[i]));
        }
    }

    void addStringFunctions() {
        for (int i = 0; i < stringFunctions.length; ++i) {
            this.addSymbol(new Symbol(stringFunctionIDs[i], stringFunctions[i]));
        }
    }

    void addArrayFunctions() {
        for (int i = 0; i < arrayFunctions.length; ++i) {
            this.addSymbol(new Symbol(arrayFunctionIDs[i], arrayFunctions[i]));
        }
    }

    void addSymbol(Symbol symbol) {
        ++this.stLoc;
        if (this.stLoc == this.table.length) {
            Symbol[] symbolArray = new Symbol[this.maxSymbols * 2];
            System.arraycopy(this.table, 0, symbolArray, 0, this.maxSymbols);
            this.table = symbolArray;
            this.maxSymbols *= 2;
        }
        this.table[this.stLoc] = symbol;
    }

    void addToken(int n, int n2) {
        ++this.pc;
        if (this.pc == this.code.length) {
            int[] nArray = new int[this.maxProgramSize * 2];
            System.arraycopy(this.code, 0, nArray, 0, this.maxProgramSize);
            this.code = nArray;
            nArray = new int[this.maxProgramSize * 2];
            System.arraycopy(this.lineNumbers, 0, nArray, 0, this.maxProgramSize);
            this.lineNumbers = nArray;
            this.maxProgramSize *= 2;
        }
        this.code[this.pc] = n;
        this.lineNumbers[this.pc] = n2;
    }

    Symbol lookupWord(String string) {
        for (int i = 0; i <= this.stLoc; ++i) {
            Symbol symbol = this.table[i];
            if (symbol.type == 133 || !string.equals(symbol.str)) continue;
            this.symTabLoc = i;
            return symbol;
        }
        return null;
    }

    void saveGlobals(Interpreter interpreter) {
        if (interpreter.topOfStack == -1) {
            return;
        }
        int n = interpreter.topOfStack + 1;
        this.globals = new Variable[n];
        for (int i = 0; i < n; ++i) {
            this.globals[i] = interpreter.stack[i];
        }
    }

    public void dumpSymbolTable() {
        Symbol symbol;
        IJ.log("");
        IJ.log("Symbol Table");
        for (int i = 0; i <= this.maxSymbols && (symbol = this.table[i]) != null; ++i) {
            IJ.log(i + " " + symbol);
        }
    }

    public void dumpProgram() {
        IJ.log("");
        IJ.log("Tokenized Program");
        for (int i = 0; i <= this.pc; ++i) {
            IJ.log(i + "\t " + this.lineNumbers[i] + "   " + (this.code[i] & 0xFFF) + "   " + this.decodeToken(this.code[i]));
        }
    }

    public Variable[] getGlobals() {
        return this.globals;
    }

    public boolean hasVars() {
        return this.hasVars;
    }

    public int macroCount() {
        return this.macroCount;
    }

    public String decodeToken(int n) {
        return this.decodeToken(n & 0xFFF, n >> 12);
    }

    String decodeToken(int n, int n2) {
        String string;
        block0 : switch (n) {
            case 129: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: {
                string = this.table[n2].str;
                break;
            }
            case 133: {
                string = "\"" + this.table[n2].str + "\"";
                break;
            }
            case 130: {
                double d = this.table[n2].value;
                if ((double)((int)d) == d) {
                    string = IJ.d2s(d, 0);
                    break;
                }
                string = "" + d;
                break;
            }
            case 128: {
                string = "EOF";
                break;
            }
            default: {
                if (n < 32) {
                    switch (n) {
                        case 1: {
                            string = "++";
                            break block0;
                        }
                        case 2: {
                            string = "--";
                            break block0;
                        }
                        case 9: {
                            string = "+=";
                            break block0;
                        }
                        case 10: {
                            string = "-=";
                            break block0;
                        }
                        case 11: {
                            string = "*=";
                            break block0;
                        }
                        case 12: {
                            string = "/=";
                            break block0;
                        }
                        case 13: {
                            string = "&&";
                            break block0;
                        }
                        case 14: {
                            string = "||";
                            break block0;
                        }
                        case 3: {
                            string = "==";
                            break block0;
                        }
                        case 4: {
                            string = "!=";
                            break block0;
                        }
                        case 5: {
                            string = ">";
                            break block0;
                        }
                        case 6: {
                            string = ">=";
                            break block0;
                        }
                        case 7: {
                            string = "<";
                            break block0;
                        }
                        case 8: {
                            string = "<=";
                            break block0;
                        }
                    }
                    string = "";
                    break;
                }
                if (n >= 200) {
                    string = this.table[n2].str;
                    break;
                }
                char[] cArray = new char[]{(char)n};
                string = new String(cArray);
            }
        }
        return string;
    }

    public Hashtable getMenus() {
        return this.menus;
    }

    public boolean hasWord(String string) {
        for (int i = 0; i < this.code.length; ++i) {
            int n = this.code[i];
            if (n <= 127) continue;
            if (n == 128) {
                return false;
            }
            int n2 = n >> 12;
            String string2 = this.table[n2].str;
            if (string2 == null || !string2.equals(string)) continue;
            return true;
        }
        return false;
    }
}

