/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.Prefs;
import ij.io.FileInfo;
import ij.io.ImageWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TiffEncoder {
    static final int HDR_SIZE = 8;
    static final int MAP_SIZE = 768;
    static final int BPS_DATA_SIZE = 6;
    static final int SCALE_DATA_SIZE = 16;
    private FileInfo fi;
    private int bitsPerSample;
    private int photoInterp;
    private int samplesPerPixel;
    private int nEntries;
    private int ifdSize;
    private long imageOffset;
    private int imageSize;
    private long stackSize;
    private byte[] description;
    private int metaDataSize;
    private int nMetaDataTypes;
    private int nMetaDataEntries;
    private int nSliceLabels;
    private int extraMetaDataEntries;
    private int scaleSize;
    private boolean littleEndian = Prefs.intelByteOrder;
    private byte[] buffer = new byte[8];

    public TiffEncoder(FileInfo fileInfo) {
        this.fi = fileInfo;
        fileInfo.intelByteOrder = this.littleEndian;
        this.bitsPerSample = 8;
        this.samplesPerPixel = 1;
        this.nEntries = 9;
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        switch (fileInfo.fileType) {
            case 0: {
                this.photoInterp = fileInfo.whiteIsZero ? 0 : 1;
                break;
            }
            case 1: 
            case 2: {
                this.bitsPerSample = 16;
                this.photoInterp = fileInfo.whiteIsZero ? 0 : 1;
                n = 2;
                break;
            }
            case 4: {
                this.bitsPerSample = 32;
                this.photoInterp = fileInfo.whiteIsZero ? 0 : 1;
                n = 4;
                break;
            }
            case 6: {
                this.photoInterp = 2;
                this.samplesPerPixel = 3;
                n = 3;
                n2 = 6;
                break;
            }
            case 12: {
                this.bitsPerSample = 16;
                this.photoInterp = 2;
                this.samplesPerPixel = 3;
                n = 6;
                fileInfo.nImages /= 3;
                n2 = 6;
                break;
            }
            case 5: {
                this.photoInterp = 3;
                this.nEntries = 10;
                n3 = 1536;
                break;
            }
            default: {
                this.photoInterp = 0;
            }
        }
        if (fileInfo.unit != null && fileInfo.pixelWidth != 0.0 && fileInfo.pixelHeight != 0.0) {
            this.nEntries += 3;
        }
        if (fileInfo.fileType == 4) {
            ++this.nEntries;
        }
        this.makeDescriptionString();
        if (this.description != null) {
            ++this.nEntries;
        }
        this.imageSize = fileInfo.width * fileInfo.height * n;
        this.stackSize = (long)this.imageSize * (long)fileInfo.nImages;
        this.metaDataSize = this.getMetaDataSize();
        if (this.metaDataSize > 0) {
            this.nEntries += 2;
        }
        this.ifdSize = 2 + this.nEntries * 12 + 4;
        int n4 = this.description != null ? this.description.length : 0;
        this.scaleSize = fileInfo.unit != null && fileInfo.pixelWidth != 0.0 && fileInfo.pixelHeight != 0.0 ? 16 : 0;
        this.imageOffset = 8 + this.ifdSize + n2 + n4 + this.scaleSize + n3 + this.nMetaDataEntries * 4 + this.metaDataSize;
        fileInfo.offset = (int)this.imageOffset;
    }

    public void write(OutputStream outputStream) throws IOException {
        this.writeHeader(outputStream);
        long l = 0L;
        if (this.fi.nImages > 1) {
            l = this.imageOffset + this.stackSize;
        }
        if (l + (long)(this.fi.nImages * this.ifdSize) >= 0xFFFFFFFFL) {
            l = 0L;
        }
        this.writeIFD(outputStream, (int)this.imageOffset, (int)l);
        if (this.fi.fileType == 6 || this.fi.fileType == 12) {
            this.writeBitsPerPixel(outputStream);
        }
        if (this.description != null) {
            this.writeDescription(outputStream);
        }
        if (this.scaleSize > 0) {
            this.writeScale(outputStream);
        }
        if (this.fi.fileType == 5) {
            this.writeColorMap(outputStream);
        }
        if (this.metaDataSize > 0) {
            this.writeMetaData(outputStream);
        }
        new ImageWriter(this.fi).write(outputStream);
        if (l > 0L) {
            int n = this.ifdSize;
            if (this.metaDataSize > 0) {
                this.metaDataSize = 0;
                this.nEntries -= 2;
                n -= 24;
            }
            for (int i = 2; i <= this.fi.nImages; ++i) {
                l = i == this.fi.nImages ? 0L : (l += (long)n);
                this.imageOffset += (long)this.imageSize;
                this.writeIFD(outputStream, (int)this.imageOffset, (int)l);
            }
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        this.write((OutputStream)dataOutputStream);
    }

    int getMetaDataSize() {
        int n;
        this.nSliceLabels = 0;
        this.nMetaDataEntries = 0;
        int n2 = 0;
        int n3 = 0;
        if (this.fi.info != null && this.fi.info.length() > 0) {
            this.nMetaDataEntries = 1;
            n2 = this.fi.info.length() * 2;
            ++n3;
        }
        if (this.fi.sliceLabels != null) {
            int n4;
            n = Math.min(this.fi.sliceLabels.length, this.fi.nImages);
            boolean bl = false;
            for (n4 = 0; n4 < n; ++n4) {
                if (this.fi.sliceLabels[n4] == null || this.fi.sliceLabels[n4].length() <= 0) continue;
                bl = true;
                break;
            }
            if (bl) {
                for (n4 = 0; n4 < n; ++n4) {
                    ++this.nSliceLabels;
                    if (this.fi.sliceLabels[n4] == null) continue;
                    n2 += this.fi.sliceLabels[n4].length() * 2;
                }
                if (this.nSliceLabels > 0) {
                    ++n3;
                }
                this.nMetaDataEntries += this.nSliceLabels;
            }
        }
        if (this.fi.displayRanges != null) {
            ++this.nMetaDataEntries;
            n2 += this.fi.displayRanges.length * 8;
            ++n3;
        }
        if (this.fi.channelLuts != null) {
            for (n = 0; n < this.fi.channelLuts.length; ++n) {
                if (this.fi.channelLuts[n] == null) continue;
                n2 += this.fi.channelLuts[n].length;
            }
            ++n3;
            this.nMetaDataEntries += this.fi.channelLuts.length;
        }
        if (this.fi.roi != null) {
            ++this.nMetaDataEntries;
            n2 += this.fi.roi.length;
            ++n3;
        }
        if (this.fi.overlay != null) {
            for (n = 0; n < this.fi.overlay.length; ++n) {
                if (this.fi.overlay[n] == null) continue;
                n2 += this.fi.overlay[n].length;
            }
            ++n3;
            this.nMetaDataEntries += this.fi.overlay.length;
        }
        if (this.fi.metaDataTypes != null && this.fi.metaData != null && this.fi.metaData[0] != null && this.fi.metaDataTypes.length == this.fi.metaData.length) {
            this.extraMetaDataEntries = this.fi.metaData.length;
            n3 += this.extraMetaDataEntries;
            this.nMetaDataEntries += this.extraMetaDataEntries;
            for (n = 0; n < this.extraMetaDataEntries; ++n) {
                if (this.fi.metaData[n] == null) continue;
                n2 += this.fi.metaData[n].length;
            }
        }
        if (this.nMetaDataEntries > 0) {
            ++this.nMetaDataEntries;
        }
        n = 4 + n3 * 8;
        if (n2 > 0) {
            n2 += n;
        }
        this.nMetaDataTypes = n3;
        return n2;
    }

    void writeHeader(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[8];
        if (this.littleEndian) {
            byArray[0] = 73;
            byArray[1] = 73;
            byArray[2] = 42;
            byArray[3] = 0;
            byArray[4] = 8;
            byArray[5] = 0;
            byArray[6] = 0;
            byArray[7] = 0;
        } else {
            byArray[0] = 77;
            byArray[1] = 77;
            byArray[2] = 0;
            byArray[3] = 42;
            byArray[4] = 0;
            byArray[5] = 0;
            byArray[6] = 0;
            byArray[7] = 8;
        }
        outputStream.write(byArray);
    }

    void writeEntry(OutputStream outputStream, int n, int n2, int n3, int n4) throws IOException {
        this.writeShort(outputStream, n);
        this.writeShort(outputStream, n2);
        this.writeInt(outputStream, n3);
        if (n3 == 1 && n2 == 3) {
            this.writeShort(outputStream, n4);
            this.writeShort(outputStream, 0);
        } else {
            this.writeInt(outputStream, n4);
        }
    }

    void writeIFD(OutputStream outputStream, int n, int n2) throws IOException {
        int n3;
        int n4 = 8 + this.ifdSize;
        this.writeShort(outputStream, this.nEntries);
        this.writeEntry(outputStream, 254, 4, 1, 0);
        this.writeEntry(outputStream, 256, 4, 1, this.fi.width);
        this.writeEntry(outputStream, 257, 4, 1, this.fi.height);
        if (this.fi.fileType == 6 || this.fi.fileType == 12) {
            this.writeEntry(outputStream, 258, 3, 3, n4);
            n4 += 6;
        } else {
            this.writeEntry(outputStream, 258, 3, 1, this.bitsPerSample);
        }
        this.writeEntry(outputStream, 262, 3, 1, this.photoInterp);
        if (this.description != null) {
            this.writeEntry(outputStream, 270, 2, this.description.length, n4);
            n4 += this.description.length;
        }
        this.writeEntry(outputStream, 273, 4, 1, n);
        this.writeEntry(outputStream, 277, 3, 1, this.samplesPerPixel);
        this.writeEntry(outputStream, 278, 3, 1, this.fi.height);
        this.writeEntry(outputStream, 279, 4, 1, this.imageSize);
        if (this.fi.unit != null && this.fi.pixelWidth != 0.0 && this.fi.pixelHeight != 0.0) {
            this.writeEntry(outputStream, 282, 5, 1, n4);
            this.writeEntry(outputStream, 283, 5, 1, n4 + 8);
            n4 += 16;
            n3 = 1;
            if (this.fi.unit.equals("inch")) {
                n3 = 2;
            } else if (this.fi.unit.equals("cm")) {
                n3 = 3;
            }
            this.writeEntry(outputStream, 296, 3, 1, n3);
        }
        if (this.fi.fileType == 4) {
            n3 = 3;
            this.writeEntry(outputStream, 339, 3, 1, n3);
        }
        if (this.fi.fileType == 5) {
            this.writeEntry(outputStream, 320, 3, 768, n4);
            n4 += 1536;
        }
        if (this.metaDataSize > 0) {
            this.writeEntry(outputStream, 50838, 4, this.nMetaDataEntries, n4);
            this.writeEntry(outputStream, 50839, 1, this.metaDataSize, n4 + 4 * this.nMetaDataEntries);
            n4 += this.nMetaDataEntries * 4 + this.metaDataSize;
        }
        this.writeInt(outputStream, n2);
    }

    void writeBitsPerPixel(OutputStream outputStream) throws IOException {
        int n = this.fi.fileType == 12 ? 16 : 8;
        this.writeShort(outputStream, n);
        this.writeShort(outputStream, n);
        this.writeShort(outputStream, n);
    }

    void writeScale(OutputStream outputStream) throws IOException {
        double d = 1.0 / this.fi.pixelWidth;
        double d2 = 1.0 / this.fi.pixelHeight;
        double d3 = 1000000.0;
        if (d > 1000.0) {
            d3 = 1000.0;
        }
        this.writeInt(outputStream, (int)(d * d3));
        this.writeInt(outputStream, (int)d3);
        this.writeInt(outputStream, (int)(d2 * d3));
        this.writeInt(outputStream, (int)d3);
    }

    void writeDescription(OutputStream outputStream) throws IOException {
        outputStream.write(this.description, 0, this.description.length);
    }

    void writeColorMap(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[1536];
        int n = this.littleEndian ? 1 : 0;
        for (int i = 0; i < this.fi.lutSize; ++i) {
            byArray[n] = this.fi.reds[i];
            byArray[512 + n] = this.fi.greens[i];
            byArray[1024 + n] = this.fi.blues[i];
            n += 2;
        }
        outputStream.write(byArray);
    }

    void writeMetaData(OutputStream outputStream) throws IOException {
        int n;
        this.writeInt(outputStream, 4 + this.nMetaDataTypes * 8);
        if (this.fi.info != null && this.fi.info.length() > 0) {
            this.writeInt(outputStream, this.fi.info.length() * 2);
        }
        for (n = 0; n < this.nSliceLabels; ++n) {
            if (this.fi.sliceLabels[n] == null) {
                this.writeInt(outputStream, 0);
                continue;
            }
            this.writeInt(outputStream, this.fi.sliceLabels[n].length() * 2);
        }
        if (this.fi.displayRanges != null) {
            this.writeInt(outputStream, this.fi.displayRanges.length * 8);
        }
        if (this.fi.channelLuts != null) {
            for (n = 0; n < this.fi.channelLuts.length; ++n) {
                this.writeInt(outputStream, this.fi.channelLuts[n].length);
            }
        }
        if (this.fi.roi != null) {
            this.writeInt(outputStream, this.fi.roi.length);
        }
        if (this.fi.overlay != null) {
            for (n = 0; n < this.fi.overlay.length; ++n) {
                this.writeInt(outputStream, this.fi.overlay[n].length);
            }
        }
        for (n = 0; n < this.extraMetaDataEntries; ++n) {
            this.writeInt(outputStream, this.fi.metaData[n].length);
        }
        this.writeInt(outputStream, 0x494A494A);
        if (this.fi.info != null) {
            this.writeInt(outputStream, 1768842863);
            this.writeInt(outputStream, 1);
        }
        if (this.nSliceLabels > 0) {
            this.writeInt(outputStream, 1818321516);
            this.writeInt(outputStream, this.nSliceLabels);
        }
        if (this.fi.displayRanges != null) {
            this.writeInt(outputStream, 1918987879);
            this.writeInt(outputStream, 1);
        }
        if (this.fi.channelLuts != null) {
            this.writeInt(outputStream, 1819636851);
            this.writeInt(outputStream, this.fi.channelLuts.length);
        }
        if (this.fi.roi != null) {
            this.writeInt(outputStream, 1919904032);
            this.writeInt(outputStream, 1);
        }
        if (this.fi.overlay != null) {
            this.writeInt(outputStream, 1870030194);
            this.writeInt(outputStream, this.fi.overlay.length);
        }
        for (n = 0; n < this.extraMetaDataEntries; ++n) {
            this.writeInt(outputStream, this.fi.metaDataTypes[n]);
            this.writeInt(outputStream, 1);
        }
        if (this.fi.info != null) {
            this.writeChars(outputStream, this.fi.info);
        }
        for (n = 0; n < this.nSliceLabels; ++n) {
            if (this.fi.sliceLabels[n] == null) continue;
            this.writeChars(outputStream, this.fi.sliceLabels[n]);
        }
        if (this.fi.displayRanges != null) {
            for (n = 0; n < this.fi.displayRanges.length; ++n) {
                this.writeDouble(outputStream, this.fi.displayRanges[n]);
            }
        }
        if (this.fi.channelLuts != null) {
            for (n = 0; n < this.fi.channelLuts.length; ++n) {
                outputStream.write(this.fi.channelLuts[n]);
            }
        }
        if (this.fi.roi != null) {
            outputStream.write(this.fi.roi);
        }
        if (this.fi.overlay != null) {
            for (n = 0; n < this.fi.overlay.length; ++n) {
                outputStream.write(this.fi.overlay[n]);
            }
        }
        for (n = 0; n < this.extraMetaDataEntries; ++n) {
            outputStream.write(this.fi.metaData[n]);
        }
    }

    void makeDescriptionString() {
        if (this.fi.description != null) {
            if (this.fi.description.charAt(this.fi.description.length() - 1) != '\u0000') {
                this.fi.description = this.fi.description + " ";
            }
            this.description = this.fi.description.getBytes();
            this.description[this.description.length - 1] = 0;
        } else {
            this.description = null;
        }
    }

    final void writeShort(OutputStream outputStream, int n) throws IOException {
        if (this.littleEndian) {
            outputStream.write(n & 0xFF);
            outputStream.write(n >>> 8 & 0xFF);
        } else {
            outputStream.write(n >>> 8 & 0xFF);
            outputStream.write(n & 0xFF);
        }
    }

    final void writeInt(OutputStream outputStream, int n) throws IOException {
        if (this.littleEndian) {
            outputStream.write(n & 0xFF);
            outputStream.write(n >>> 8 & 0xFF);
            outputStream.write(n >>> 16 & 0xFF);
            outputStream.write(n >>> 24 & 0xFF);
        } else {
            outputStream.write(n >>> 24 & 0xFF);
            outputStream.write(n >>> 16 & 0xFF);
            outputStream.write(n >>> 8 & 0xFF);
            outputStream.write(n & 0xFF);
        }
    }

    final void writeLong(OutputStream outputStream, long l) throws IOException {
        if (this.littleEndian) {
            this.buffer[7] = (byte)(l >>> 56);
            this.buffer[6] = (byte)(l >>> 48);
            this.buffer[5] = (byte)(l >>> 40);
            this.buffer[4] = (byte)(l >>> 32);
            this.buffer[3] = (byte)(l >>> 24);
            this.buffer[2] = (byte)(l >>> 16);
            this.buffer[1] = (byte)(l >>> 8);
            this.buffer[0] = (byte)l;
            outputStream.write(this.buffer, 0, 8);
        } else {
            this.buffer[0] = (byte)(l >>> 56);
            this.buffer[1] = (byte)(l >>> 48);
            this.buffer[2] = (byte)(l >>> 40);
            this.buffer[3] = (byte)(l >>> 32);
            this.buffer[4] = (byte)(l >>> 24);
            this.buffer[5] = (byte)(l >>> 16);
            this.buffer[6] = (byte)(l >>> 8);
            this.buffer[7] = (byte)l;
            outputStream.write(this.buffer, 0, 8);
        }
    }

    final void writeDouble(OutputStream outputStream, double d) throws IOException {
        this.writeLong(outputStream, Double.doubleToLongBits(d));
    }

    final void writeChars(OutputStream outputStream, String string) throws IOException {
        int n = string.length();
        if (this.littleEndian) {
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                outputStream.write(c & 0xFF);
                outputStream.write(c >>> 8 & 0xFF);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                outputStream.write(c >>> 8 & 0xFF);
                outputStream.write(c & 0xFF);
            }
        }
    }
}

