/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Rectangle;
import java.awt.image.ColorModel;

public class ImageStack {
    static final int INITIAL_SIZE = 25;
    static final String outOfRange = "Argument out of range: ";
    private int nSlices = 0;
    private Object[] stack;
    private String[] label;
    private int width;
    private int height;
    private Rectangle roi;
    private ColorModel cm;
    private double min = Double.MAX_VALUE;
    private double max;
    private float[] cTable;

    public ImageStack() {
    }

    public ImageStack(int n, int n2) {
        this(n, n2, null);
    }

    public ImageStack(int n, int n2, int n3) {
        this.width = n;
        this.height = n2;
        this.stack = new Object[n3];
        this.label = new String[n3];
        this.nSlices = n3;
    }

    public ImageStack(int n, int n2, ColorModel colorModel) {
        this.width = n;
        this.height = n2;
        this.cm = colorModel;
        this.stack = new Object[25];
        this.label = new String[25];
        this.nSlices = 0;
    }

    public void addSlice(String string, Object object) {
        if (object == null) {
            throw new IllegalArgumentException("'pixels' is null!");
        }
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException("'pixels' is not an array");
        }
        ++this.nSlices;
        if (this.nSlices >= this.stack.length) {
            Object[] objectArray = new Object[this.nSlices * 2];
            System.arraycopy(this.stack, 0, objectArray, 0, this.stack.length);
            this.stack = objectArray;
            String[] stringArray = new String[this.nSlices * 2];
            System.arraycopy(this.label, 0, stringArray, 0, this.label.length);
            this.label = stringArray;
        }
        this.stack[this.nSlices - 1] = object;
        this.label[this.nSlices - 1] = string;
    }

    public void addUnsignedShortSlice(String string, Object object) {
        this.addSlice(string, object);
    }

    public void addSlice(String string, ImageProcessor imageProcessor) {
        if (imageProcessor.getWidth() != this.width || imageProcessor.getHeight() != this.height) {
            throw new IllegalArgumentException("Dimensions do not match");
        }
        if (this.nSlices == 0) {
            this.cm = imageProcessor.getColorModel();
            this.min = imageProcessor.getMin();
            this.max = imageProcessor.getMax();
        }
        this.addSlice(string, imageProcessor.getPixels());
    }

    public void addSlice(String string, ImageProcessor imageProcessor, int n) {
        if (n < 0 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        this.addSlice(string, imageProcessor);
        Object object = this.stack[this.nSlices - 1];
        String string2 = this.label[this.nSlices - 1];
        int n2 = n > 0 ? n : 1;
        for (int i = this.nSlices - 1; i >= n2; --i) {
            this.stack[i] = this.stack[i - 1];
            this.label[i] = this.label[i - 1];
        }
        this.stack[n] = object;
        this.label[n] = string2;
    }

    public void deleteSlice(int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        if (this.nSlices < 1) {
            return;
        }
        for (int i = n; i < this.nSlices; ++i) {
            this.stack[i - 1] = this.stack[i];
            this.label[i - 1] = this.label[i];
        }
        this.stack[this.nSlices - 1] = null;
        this.label[this.nSlices - 1] = null;
        --this.nSlices;
    }

    public void deleteLastSlice() {
        if (this.nSlices > 0) {
            this.deleteSlice(this.nSlices);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setRoi(Rectangle rectangle) {
        this.roi = rectangle;
    }

    public Rectangle getRoi() {
        if (this.roi == null) {
            return new Rectangle(0, 0, this.width, this.height);
        }
        return this.roi;
    }

    public void update(ImageProcessor imageProcessor) {
        if (imageProcessor != null) {
            this.min = imageProcessor.getMin();
            this.max = imageProcessor.getMax();
            this.cTable = imageProcessor.getCalibrationTable();
            this.cm = imageProcessor.getColorModel();
        }
    }

    public Object getPixels(int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        return this.stack[n - 1];
    }

    public void setPixels(Object object, int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        this.stack[n - 1] = object;
    }

    public Object[] getImageArray() {
        return this.stack;
    }

    public int getSize() {
        return this.nSlices;
    }

    public String[] getSliceLabels() {
        if (this.nSlices == 0) {
            return null;
        }
        return this.label;
    }

    public String getSliceLabel(int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        return this.label[n - 1];
    }

    public String getShortSliceLabel(int n) {
        int n2;
        String string = this.getSliceLabel(n);
        if (string == null) {
            return null;
        }
        int n3 = string.indexOf(10);
        if (n3 == 0) {
            return null;
        }
        if (n3 > 0) {
            string = string.substring(0, n3);
        }
        if ((n2 = string.length()) > 4 && string.charAt(n2 - 4) == '.' && !Character.isDigit(string.charAt(n2 - 1))) {
            string = string.substring(0, n2 - 4);
        }
        if (string.length() > 60) {
            string = string.substring(0, 60);
        }
        return string;
    }

    public void setSliceLabel(String string, int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        this.label[n - 1] = string;
    }

    public ImageProcessor getProcessor(int n) {
        ImageProcessor imageProcessor;
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        if (this.nSlices == 0) {
            return null;
        }
        if (this.stack[0] == null) {
            throw new IllegalArgumentException("Pixel array is null");
        }
        if (this.stack[0] instanceof byte[]) {
            imageProcessor = new ByteProcessor(this.width, this.height, null, this.cm);
        } else if (this.stack[0] instanceof short[]) {
            imageProcessor = new ShortProcessor(this.width, this.height, null, this.cm);
        } else if (this.stack[0] instanceof int[]) {
            imageProcessor = new ColorProcessor(this.width, this.height, null);
        } else if (this.stack[0] instanceof float[]) {
            imageProcessor = new FloatProcessor(this.width, this.height, null, this.cm);
        } else {
            throw new IllegalArgumentException("Unknown stack type");
        }
        imageProcessor.setPixels(this.stack[n - 1]);
        if (this.min != Double.MAX_VALUE && imageProcessor != null && !(imageProcessor instanceof ColorProcessor)) {
            imageProcessor.setMinAndMax(this.min, this.max);
        }
        if (this.cTable != null) {
            imageProcessor.setCalibrationTable(this.cTable);
        }
        return imageProcessor;
    }

    public void setColorModel(ColorModel colorModel) {
        this.cm = colorModel;
    }

    public ColorModel getColorModel() {
        return this.cm;
    }

    public boolean isRGB() {
        return this.nSlices == 3 && this.stack[0] instanceof byte[] && this.getSliceLabel(1) != null && this.getSliceLabel(1).equals("Red");
    }

    public boolean isHSB() {
        return this.nSlices == 3 && this.getSliceLabel(1) != null && this.getSliceLabel(1).equals("Hue");
    }

    public boolean isVirtual() {
        return false;
    }

    public void trim() {
        int n = (int)Math.round(Math.log(this.nSlices) + 1.0);
        for (int i = 0; i < n; ++i) {
            this.deleteLastSlice();
            System.gc();
        }
    }

    public String toString() {
        String string = this.isVirtual() ? "(V)" : "";
        return "stack[" + this.getWidth() + "x" + this.getHeight() + "x" + this.getSize() + string + "]";
    }
}

