/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security.token;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.TokenIdentifier;

public class JobTokenIdentifier
extends TokenIdentifier {
    private Text jobid;
    static final Text KIND_NAME = new Text("mapreduce.job");

    public JobTokenIdentifier() {
        this.jobid = new Text();
    }

    public JobTokenIdentifier(Text jobid) {
        this.jobid = jobid;
    }

    @Override
    public Text getKind() {
        return KIND_NAME;
    }

    @Override
    public UserGroupInformation getUser() {
        if (this.jobid == null || "".equals(this.jobid.toString())) {
            return null;
        }
        return UserGroupInformation.createRemoteUser(this.jobid.toString());
    }

    public Text getJobId() {
        return this.jobid;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.jobid.readFields(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.jobid.write(out);
    }
}

