/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Session;
import org.h2.message.Message;

public class DropFunctionAlias
extends DefineCommand {
    private String aliasName;
    private boolean ifExists;

    public DropFunctionAlias(Session session) {
        super(session);
    }

    public int update() throws SQLException {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        FunctionAlias functionAlias = database.findFunctionAlias(this.aliasName);
        if (functionAlias == null) {
            if (!this.ifExists) {
                throw Message.getSQLException(90077, this.aliasName);
            }
        } else {
            database.removeDatabaseObject(this.session, functionAlias);
        }
        return 0;
    }

    public void setAliasName(String string) {
        this.aliasName = string;
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }
}

