% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsPreview.R
\name{lsPreview}
\alias{lsPreview}
\title{Preview Landsat-7 or Landsat-8 satellite images}
\usage{
lsPreview(
  searchres,
  n,
  dates,
  lpos = c(3, 2, 1),
  add.Layer = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{searchres}{a \code{data.frame} with the results from 
\code{\link{ls7Search}} or \code{\link{ls8Search}}.}

\item{n}{a \code{numeric} argument identifying the location of the image in
\code{searchres}.}

\item{dates}{a vector of \code{Date}s being considered
for previewing. This argument is mandatory if 
\code{n} is not defined.}

\item{lpos}{vector argument. Defines the position of the red-green-blue
layers to enable false color visualization.}

\item{add.Layer}{logical argument. If \code{TRUE}, the function plots the 
image on an existing map. Allows combinations of images on a map using 
\code{\link{senPreview}} and \code{\link{modPreview}} functions.}

\item{verbose}{logical argument. If \code{TRUE}, the function prints the 
running steps and warnings.}

\item{...}{arguments for nested functions:
 \itemize{
  \item arguments allowed by the \code{viewRGB} function from the 
  \code{mapview} packages are valid arguments.
}}
}
\value{
this function does not return anything. It displays a preview of
 one of the search results.
}
\description{
\code{lsPreview} shows a preview of the \code{n}-th image from a set of 
search results on an interactive map.
}
\details{
The function shows a preview of the \code{n}-th output image from a search
in the Landsat archives (\code{\link{ls7Search}} or \code{\link{ls8Search}},
with \code{browseAvailable = "Y"}). The preview is downloaded from 
\href{https://www.usgs.gov/land-resources/nli/landsat/bulk-metadata-service}{USGS Bulk Metadata Service}.
Please, be aware that only some images may have a preview.
}
\examples{
\dontrun{
# load a spatial polygon object of Navarre
data(ex.navarre)
wdir <- file.path(tempdir(),"Path_for_downloading_folder")
# retrieve jpg images covering Navarre between 2011 and 2013
sres <- ls7Search(startDate = as.Date("01-01-2011", "\%d-\%m-\%Y"),
                  endDate = as.Date("31-12-2013", "\%d-\%m-\%Y"),
                  extent = ex.navarre,
                  precise = TRUE,
                  browseAvaliable = "Y",
                  AppRoot = wdir)
lsPreview(sres, 1)
# filter the images with less than 1\% pixels covered by clouds
sres.cloud.free = subset(sres, sres$cloudCover < 1)
lsPreview(sres.cloud.free, 1)
lsPreview(sres.cloud.free, 2,add.Layer = TRUE)
# plot all the images in one date
lsPreview(sres.cloud.free,dates=as.Date("2013-09-04"))
}
}
