% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wsmooth.R
\name{wsmooth}
\alias{wsmooth}
\title{Bidimensional smoothing}
\usage{
wsmooth(chromatogram, penalty = 1, lambda = 1)
}
\arguments{
\item{chromatogram}{\emph{raw_GCxGC} or \emph{preproc_GCxGC} object like with
provided \emph{name} and \emph{mod_time} slots.}

\item{penalty}{an integer of the order of the penalty. Only penalty of
first (penalty = 1) and second order (penalty = 2) are allowed. By
default it is performed with first penalty order.}

\item{lambda}{smoothing parameter: larger values lead to more smoothing.}
}
\description{
`wsmooth` provides a bidimensional weighted whittaker
  smoothing of a two dimensional chromatogram
}
\details{
This function takes a raw bidimensional chromatogram and performs
 the weighted wittaker smoothing. It smooths with linear or cuadratic penalty
 along side the first dimension, based on Whittaker smoother
 \insertCite{Eilers2003}{RGCxGC}.
}
\examples{

chrom_name <- system.file("extdata", "08GB.cdf", package = "RGCxGC")
chrom_2D <- read_chrom(chrom_name, 5L)
chrom_smooth <- wsmooth(chrom_2D, penalty = 1, lambda = 1e1)
plot(chrom_smooth, nlevels = 150,
           color.palette = colorRamps::matlab.like,
           main = expression(paste(lambda, "= 10, penalty = 1")) )

}
\references{
\insertAllCited{}
}
