% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.bootstrap.r
\name{print.bootstrap}
\alias{print.bootstrap}
\title{Print a rgcca_bootstrap object}
\usage{
\method{print}{bootstrap}(
  x,
  block = seq_along(x$rgcca$call$blocks),
  comp = 1,
  type = "weights",
  empirical = TRUE,
  display_order = FALSE,
  adj.method = "fdr",
  ...
)
}
\arguments{
\item{x}{A fitted rgcca_bootstrap object
(see \code{\link[RGCCA]{rgcca_bootstrap}})}

\item{block}{A numeric corresponding to the block(s) to plot.}

\item{comp}{A numeric vector indicating the component(s) to consider.}

\item{type}{A string indicating the bootstrapped object to plot:
block-weight vectors ("weights", default) or block-loading vectors
("loadings").}

\item{empirical}{A logical value indicating if the bootstrap confidence
intervals and p-values are derived from the empirical distribution.
(default: TRUE)}

\item{display_order}{A logical value for ordering the variables. If TRUE,
variables are ordered from highest to lowest absolute value. If FALSE,
the block order is used. Default is TRUE.}

\item{adj.method}{A string indicating the method used to adjust the p-values.
It must be a method handled by the p.adjust function. Default is "fdr".}

\item{...}{Other parameters used in print (for the displaying of matrices).}
}
\value{
none
}
\description{
Print a fitted rgcca_bootstrap object. Parameters of the
analysis and bootstrap statistics are displayed.
}
\examples{
data("Russett")
blocks <- list(
  agriculture = Russett[, seq(3)],
  industry = Russett[, 4:5],
  politic = Russett[, 6:11]
)
fit.rgcca <- rgcca(blocks, ncomp = c(2, 1, 2))
boot.out <- rgcca_bootstrap(fit.rgcca, n_boot = 20, n_cores = 2,
                            verbose = TRUE)
print(boot.out)
}
