% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.permutation.R
\name{plot.permutation}
\alias{plot.permutation}
\title{Plot a fitted rgcca permutation object}
\usage{
\method{plot}{permutation}(
  x,
  type = "crit",
  cex = 1,
  title = NULL,
  cex_main = 14 * cex,
  cex_sub = 12 * cex,
  cex_point = 3 * cex,
  cex_lab = 12 * cex,
  display_order = TRUE,
  show_legend = FALSE,
  ...
)
}
\arguments{
\item{x}{A fitted rgcca_permutation object (see
\code{\link[RGCCA]{rgcca_permutation}}).}

\item{type}{A string indicating which criterion to plot. Default
is 'crit' for the RGCCA criterion. Otherwise, the pseudo Z-score is used.}

\item{cex}{A numeric defining the size of the objects in the plot. Default
is one.}

\item{title}{A string specifying the title of the plot.}

\item{cex_main}{A numeric defining the font size of the title. Default is
14 * cex.}

\item{cex_sub}{A numeric defining the font size of the subtitle. Default is
12 * cex.}

\item{cex_point}{A numeric defining the font size of the points. Default is
3 * cex.}

\item{cex_lab}{A numeric defining the font size of the labels. Default is
12 * cex.}

\item{display_order}{A logical value for ordering the variables. If TRUE,
variables are ordered from highest to lowest absolute value. If FALSE,
the block order is used. Default is TRUE.}

\item{show_legend}{A logical value indicating if legend should
be shown (default is FALSE).}

\item{...}{Additional graphical parameters.}
}
\value{
A ggplot2 plot object.
}
\description{
Plot a fitted rgcca permutation object. The set of candidate tuning
parameters
are represented on the y-axis and the RGCCA objective function - obtained
from both the original and permuted blocks - on the x-axis. If type =
"zstat" the value of the zstat for the various parameter sets are reported on
the x-axis.
}
\examples{
data(Russett)
A <- list(
  agriculture = Russett[, seq(3)],
  industry = Russett[, 4:5],
  politic = Russett[, 6:11]
)

perm_out <- rgcca_permutation(A, par_type = "tau",
                              n_perms = 2, n_cores = 1,
                              verbose = FALSE)
print(perm_out)
plot(perm_out)

perm.out <- rgcca_permutation(A,
  par_type = "sparsity",
  n_perms = 5, n_cores = 1,
  verbose = FALSE
)

print(perm.out)
plot(perm.out, type = "zstat")
}
