% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nawru.R
\name{plot.NAWRUfit}
\alias{plot.NAWRUfit}
\title{Plots for a \code{NAWRUfit} object}
\usage{
\method{plot}{NAWRUfit}(
  x,
  alpha = 0.05,
  bounds = TRUE,
  path = NULL,
  combine = TRUE,
  prefix = NULL,
  posterior = FALSE,
  device = "png",
  width = 10,
  height = 3,
  ...
)
}
\arguments{
\item{x}{An object of class \code{NAWRUfit}.}

\item{alpha}{The significance level for the NAWRU (\code{alpha in [0,1]}). Only used if
\code{bounds = TRUE}.}

\item{bounds}{A logical indicating whether significance intervals should be plotted around
the nawru. The default is \code{bounds = TRUE}.}

\item{path}{An optional file path. If specified, the plots will be saved using the format
in \code{device} under the given path.}

\item{combine}{A logical indicating whether the diagnostic plots should be combined or not,
the default is \code{TRUE}.}

\item{prefix}{An optional character string to be added to the names of the plots in case
\code{path} is specified.}

\item{posterior}{A logical indicating whether posterior diagnostics should be plotted. The
default is \code{FALSE}. Only applied in the case of bayesian estimation.}

\item{device}{Device passed on to \code{ggplot} for plot saving. Options are 
\code{"eps", "ps", "tex"} (pictex), \code{"pdf", "jpeg", "tiff", "png", "bmp", "svg"} 
or \code{"wmf"}.}

\item{width}{The plot width in case of printing.}

\item{height}{The plot height in case of printing.}

\item{...}{Ignored.}
}
\value{
No return value, plots are printed.
}
\description{
Plots the NAWRU and the Phillip's curve and gives diagnostic plots based on
standardized residuals for objects of class \code{NAWRUfit}.
}
