% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfp_bayesian.R
\name{.BayesFitTFP}
\alias{.BayesFitTFP}
\title{Estimates the parameters and states of a two-dimensional state-space model by Bayesian
methods to obtain the tfp trend.}
\usage{
.BayesFitTFP(
  model,
  prior = initializePrior(model),
  R = 10000,
  burnin = ceiling(R/10),
  thin = 1,
  HPDIprob = 0.85,
  FUN = mean,
  MLEfit = NULL
)
}
\arguments{
\item{model}{An object of class TFPmodel.}

\item{prior}{A list of matrices with parameters for the prior distribution and box
constraints. By default, \code{prior} is initialized by \code{initializePrior(model)}.
See details. Only used if \code{method = "bayesian"}.}

\item{R}{An integer specifying the number of MCMC draws. The default is \code{R = 10000}.
Only used if \code{method = "bayesian"}.}

\item{burnin}{An integer specifying the burn-in phase of the MCMC chain. The default is
\code{burnin = ceiling(R / 10)}. Only used if \code{method = "bayesian"}.}

\item{thin}{An integer specifying the thinning interval between consecutive draws. The
default is \code{thin = 1}, implying that no draws are dopped. For \code{thin = 2},
every second draw is dropped and so on. Only used if \code{method = "bayesian"}.}

\item{HPDIprob}{A numeric in the interval \code{(0,1)} specifying the target probability
of the highest posterior density intervals. The default is \code{HPDIprob = 0.9}. Only
used if \code{method = "bayesian"}.}

\item{FUN}{A function to be used to compute estimates from the posterior distribution.
Possible options are \code{"mean"} and \code{"median"}. The default is \code{FUN = "mean"}.
Only used if \code{method = "bayesian"}.}

\item{MLEfit}{(Optional) An object of class \code{TFPfit} which is used for
initialization. Only used if \code{method = "bayesian"}.}
}
\description{
Estimates the parameters and states of a two-dimensional state-space model by Bayesian
methods to obtain the tfp trend.
}
\keyword{internal}
