/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.split;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.HasFloatingNumberOfOutPorts;
import freak.core.graph.OperatorGraph;
import freak.core.graph.Split;
import freak.core.modulesupport.Module;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.population.Population;
import java.util.Iterator;

public class RandomSplit
extends Split
implements HasFloatingNumberOfOutPorts,
Module,
CompatibleWithDifferentSearchSpaces {
    public RandomSplit(OperatorGraph graph) {
        super(graph);
    }

    public IndividualList[] process(IndividualList[] origin) {
        int noOfListsToGenerate = this.getNumberOfOutPorts();
        if (noOfListsToGenerate == 0) {
            return new IndividualList[0];
        }
        if (noOfListsToGenerate == 1) {
            return origin;
        }
        Iterator iterator = origin[0].iterator();
        IndividualList[] result = new IndividualList[noOfListsToGenerate];
        int i = 0;
        while (i < noOfListsToGenerate) {
            result[i] = new Population(this.graph.getSchedule());
            ++i;
        }
        Individual ind = null;
        RandomElement randomGen = this.graph.getSchedule().getRandomElement();
        while (iterator.hasNext()) {
            ind = (Individual)iterator.next();
            int list = randomGen.choose(0, noOfListsToGenerate - 1);
            result[list].addIndividual(ind);
        }
        return result;
    }

    public String getName() {
        return "RandomSplit";
    }

    public String getDescription() {
        return "Splits the incoming individuals into several output-lists.";
    }
}

