/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.pointset;

import freak.core.control.Schedule;
import freak.core.modulesupport.Configurable;
import freak.core.population.Genotype;
import freak.module.fitness.pointset.AbstractAdjustableStaticMultiObjectiveRR;
import freak.module.fitness.pointset.LTSAdjust;
import freak.module.fitness.pointset.WrongNumberOfPointsException;

public class LtSParetoOptimization
extends AbstractAdjustableStaticMultiObjectiveRR
implements Configurable {
    public LtSParetoOptimization(Schedule schedule) {
        super(schedule, new LTSAdjust());
        this.m_zName = "LTS (Least Trimmed Squares) Pareto";
    }

    public String getDescription() {
        return "The fitness value of an individual is the least squares error of the  subset of points represented by the given individual.\n We restrict the search to subsets of size d for d-dimensional points, because they uniquely describe possible solutions.";
    }

    public int getDimensionOfObjectiveSpace() {
        return 2;
    }

    protected double[] evaluate(Genotype genotype) {
        double[] fitness = new double[2];
        try {
            this.calculateResiduals(genotype);
        }
        catch (WrongNumberOfPointsException e) {
            fitness[0] = e.getErrorFitnessValue() + this.offset;
            fitness[1] = Double.NEGATIVE_INFINITY;
            return fitness;
        }
        this.adjustHyperplane(genotype);
        if (this.interceptAdjust) {
            this.adjustIntercept(genotype);
        }
        this.rememberChoosenParameters();
        fitness[0] = this.evaluateResiduals();
        fitness[1] = this.evaluateOLSFitOnH(genotype);
        return fitness;
    }

    protected double evaluateResiduals() {
        return this.evaluateResiduals(this.h);
    }
}

