/*
 * Decompiled with CFR 0.152.
 */
package freak.rinterface.model;

import freak.Freak;
import freak.module.searchspace.logictree.DNFTree;
import freak.rinterface.model.IndividualSummary;
import freak.rinterface.model.SDataFrame;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RReturns {
    private static int generationFound = Integer.MAX_VALUE;
    private static double bestMCRinTestData = Double.MAX_VALUE;
    private static Vector<IndividualSummary> allMCRinTestData = new Vector();
    private static Vector<IndividualSummary> allMCRinTrainingData = new Vector();
    private static Vector<Double> bestMCRForLength = new Vector();
    private static Vector<Double> bestMajorityMCRForLength = new Vector();
    private static Vector<Double> bestMCRTrainingForLength = new Vector();
    private static Vector<Integer> lengths = new Vector();
    private static int[] bestBitSet;
    private static int[] resultBitSet;
    private static int lengthOfChosen;
    private static double improvement;
    private static double bestMCRChosen;
    private static SDataFrame dataFrame;
    private static int[] chosenIndices;
    private static double[] fittedHyperplane;
    private static double residual;
    private static DNFTree[] allTrees;

    static {
        improvement = 0.02;
        chosenIndices = null;
        fittedHyperplane = null;
        residual = Double.MAX_VALUE;
    }

    public static void clear() {
        Freak.debug("Clearing stored return parameters", 4);
        generationFound = Integer.MAX_VALUE;
        bestMCRinTestData = Double.MAX_VALUE;
        allMCRinTestData = new Vector();
        allMCRinTrainingData = new Vector();
        bestMCRForLength = new Vector();
        bestMajorityMCRForLength = new Vector();
        bestMCRTrainingForLength = new Vector();
        lengths = new Vector();
        dataFrame = new SDataFrame();
    }

    public static double getBestMCRinTestData() {
        return bestMCRinTestData;
    }

    public static void setBestMCRinTestData(double bestMCRinTestData) {
        RReturns.bestMCRinTestData = bestMCRinTestData;
    }

    public static Vector<IndividualSummary> getAllMCRinTestData() {
        return allMCRinTestData;
    }

    public static Vector<IndividualSummary> getAllMCRinTrainingData() {
        return allMCRinTrainingData;
    }

    public static double[] getBestMCRinTestDataWRTTraining() {
        Vector<BitSet> testBitsets = new Vector<BitSet>();
        Collections.sort(allMCRinTrainingData);
        Collections.sort(allMCRinTestData);
        int lastLength = -1;
        double bestMCRTrainLength = Double.MAX_VALUE;
        double bestMCRLength = Double.MAX_VALUE;
        double bestMCRTrain = Double.MAX_VALUE;
        double bestMCR = Double.MAX_VALUE;
        double bestTrainGecco1 = Double.MAX_VALUE;
        double bestMCRGecco1 = Double.MAX_VALUE;
        double bestTrainGecco2 = Double.MAX_VALUE;
        double bestMCRGecco2 = Double.MAX_VALUE;
        Iterator<IndividualSummary> it1 = allMCRinTrainingData.iterator();
        Iterator<IndividualSummary> it2 = allMCRinTestData.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            BitSet meanBitset;
            int i;
            double[] meanValues;
            IndividualSummary trainIndividual = it1.next();
            IndividualSummary testIndividual = it2.next();
            double trainMCR = trainIndividual.getMcr();
            double trainGecco1 = trainIndividual.getGeccoFit1();
            double trainGecco2 = trainIndividual.getGeccoFit2();
            double testMCR = testIndividual.getMcr();
            if (trainIndividual.getLength() > lastLength) {
                if (lastLength > 0) {
                    lengths.add(new Integer(lastLength));
                    bestMCRForLength.add(new Double(bestMCRLength));
                    bestMCRTrainingForLength.add(new Double(bestMCRTrainLength));
                    meanValues = new double[testIndividual.getRows()];
                    Arrays.fill(meanValues, 0.0);
                    for (BitSet bs : testBitsets) {
                        i = 0;
                        while (i < meanValues.length) {
                            if (bs.get(i)) {
                                int n = i;
                                meanValues[n] = meanValues[n] + 1.0;
                            }
                            ++i;
                        }
                    }
                    meanBitset = new BitSet(meanValues.length);
                    meanBitset.clear();
                    i = 0;
                    while (i < meanValues.length) {
                        if (meanValues[i] / (double)testBitsets.size() > 0.5) {
                            meanBitset.set(i);
                        }
                        ++i;
                    }
                    meanBitset.xor(testIndividual.getResultBitset());
                    bestMajorityMCRForLength.add(new Double((double)meanBitset.cardinality() / (double)meanValues.length));
                }
                lastLength = trainIndividual.getLength();
                bestMCRTrainLength = Double.MAX_VALUE;
                bestMCRLength = Double.MAX_VALUE;
                testBitsets = new Vector();
            }
            if (trainMCR <= bestMCRTrainLength) {
                if (trainMCR < bestMCRTrainLength) {
                    testBitsets = new Vector();
                    testBitsets.add(testIndividual.getValueBitset());
                    bestMCRTrainLength = trainMCR;
                    bestMCRLength = testMCR;
                } else {
                    testBitsets.add(testIndividual.getValueBitset());
                }
            }
            if (trainMCR < bestMCRTrain) {
                bestMCRTrain = trainMCR;
                bestMCR = testMCR;
                RReturns.setBestBitSet(testIndividual.getValueBitset(), testIndividual.getRows());
                RReturns.setResultBitSet(testIndividual.getResultBitset(), testIndividual.getRows());
            }
            if (trainGecco1 < bestTrainGecco1) {
                bestTrainGecco1 = trainGecco1;
                bestMCRGecco1 = testMCR;
            }
            if (trainGecco2 < bestTrainGecco2) {
                bestTrainGecco2 = trainGecco2;
                bestMCRGecco2 = testMCR;
            }
            if (it1.hasNext()) continue;
            lengths.add(new Integer(lastLength));
            bestMCRForLength.add(new Double(bestMCRLength));
            bestMCRTrainingForLength.add(new Double(bestMCRTrainLength));
            meanValues = new double[testIndividual.getRows()];
            Arrays.fill(meanValues, 0.0);
            for (BitSet bs : testBitsets) {
                i = 0;
                while (i < meanValues.length) {
                    if (bs.get(i)) {
                        int n = i;
                        meanValues[n] = meanValues[n] + 1.0;
                    }
                    ++i;
                }
            }
            meanBitset = new BitSet(meanValues.length);
            meanBitset.clear();
            i = 0;
            while (i < meanValues.length) {
                if (meanValues[i] / (double)testBitsets.size() > 0.5) {
                    meanBitset.set(i);
                }
                ++i;
            }
            meanBitset.xor(testIndividual.getResultBitset());
            bestMajorityMCRForLength.add(new Double((double)meanBitset.cardinality() / (double)meanValues.length));
            testBitsets = new Vector();
        }
        lengthOfChosen = 0;
        double mcrOfChosenTrain = Double.MAX_VALUE;
        double mcrOfChosen = Double.MAX_VALUE;
        Iterator<Integer> it3 = lengths.iterator();
        Iterator<Double> it4 = bestMCRTrainingForLength.iterator();
        Iterator<Double> it5 = bestMCRForLength.iterator();
        while (it3.hasNext() && it4.hasNext() && it5.hasNext()) {
            int length = it3.next();
            double trainMCR = it4.next();
            double testMCR = it5.next();
            if (!(trainMCR < Math.pow(1.0 - improvement, length - lengthOfChosen) * mcrOfChosenTrain)) continue;
            lengthOfChosen = length;
            mcrOfChosenTrain = trainMCR;
            mcrOfChosen = testMCR;
        }
        double[] returnValue = new double[]{bestMCR, mcrOfChosen, bestMCRGecco1, bestMCRGecco2};
        return returnValue;
    }

    public static double[] getBestMCRForLength() {
        double[] returnArray = new double[bestMCRForLength.size()];
        Iterator<Double> it = bestMCRForLength.iterator();
        int index = 0;
        while (it.hasNext()) {
            returnArray[index] = it.next();
            ++index;
        }
        return returnArray;
    }

    public static double[] getBestMCRTrainingForLength() {
        double[] returnArray = new double[bestMCRTrainingForLength.size()];
        Iterator<Double> it = bestMCRTrainingForLength.iterator();
        int index = 0;
        while (it.hasNext()) {
            returnArray[index] = it.next();
            ++index;
        }
        return returnArray;
    }

    public static int[] getLengths() {
        int[] returnArray = new int[lengths.size()];
        Iterator<Integer> it = lengths.iterator();
        int index = 0;
        while (it.hasNext()) {
            returnArray[index] = it.next();
            ++index;
        }
        return returnArray;
    }

    public static int getLengthOfChosen() {
        return lengthOfChosen;
    }

    public static double[] getBestMajorityMCRForLength() {
        double[] returnArray = new double[bestMajorityMCRForLength.size()];
        Iterator<Double> it = bestMajorityMCRForLength.iterator();
        int index = 0;
        while (it.hasNext()) {
            returnArray[index] = it.next();
            ++index;
        }
        return returnArray;
    }

    public static void setAllMCRinTestData(Vector<IndividualSummary> allMCRinTestData) {
        RReturns.allMCRinTestData = allMCRinTestData;
    }

    public static void setAllMCRinTrainingData(Vector<IndividualSummary> allMCRinTrainingData) {
        RReturns.allMCRinTrainingData = allMCRinTrainingData;
    }

    public static int[] getBestBitSet() {
        return bestBitSet;
    }

    public static void setBestBitSet(BitSet bestBitSetOriginal, int length) {
        int[] bestBitSet = new int[length];
        Arrays.fill(bestBitSet, 0);
        int i = 0;
        while (i < length) {
            if (bestBitSetOriginal.get(i)) {
                bestBitSet[i] = 1;
            }
            ++i;
        }
        RReturns.bestBitSet = bestBitSet;
    }

    public static int[] getResultBitSet() {
        return resultBitSet;
    }

    public static void setResultBitSet(BitSet resultBitSetOriginal, int length) {
        int[] resultBitSet = new int[length];
        Arrays.fill(resultBitSet, 0);
        int i = 0;
        while (i < length) {
            if (resultBitSetOriginal.get(i)) {
                resultBitSet[i] = 1;
            }
            ++i;
        }
        RReturns.resultBitSet = resultBitSet;
    }

    public static SDataFrame getDataFrame() {
        return dataFrame;
    }

    public static void setDataFrame(SDataFrame dataFrame) {
        RReturns.dataFrame = dataFrame;
    }

    public static int[] getChosenIndices() {
        return chosenIndices;
    }

    public static void setChosenIndices(int[] chosenIndices) {
        RReturns.chosenIndices = chosenIndices;
    }

    public static double[] getFittedHyperplane() {
        return fittedHyperplane;
    }

    public static void setFittedHyperplane(double[] fittedHyperplane) {
        RReturns.fittedHyperplane = fittedHyperplane;
    }

    public static double getResidual() {
        return residual;
    }

    public static void setResidual(double residual) {
        RReturns.residual = residual;
    }

    public static DNFTree[] getAllTrees() {
        return allTrees;
    }

    public static void setAllTrees(DNFTree[] allTrees) {
        RReturns.allTrees = allTrees;
    }

    public static void setAllTrees(Vector<DNFTree> allTrees) {
        RReturns.allTrees = new DNFTree[allTrees.size()];
        allTrees.copyInto(RReturns.allTrees);
    }

    public static int getGenerationFound() {
        return generationFound;
    }

    public static void setGenerationFound(int generationFound) {
        RReturns.generationFound = generationFound;
    }
}

