/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.selection.booleanfunction;

import freak.core.control.Schedule;
import freak.core.graph.OperatorGraph;
import freak.core.graph.Selection;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.population.Population;
import freak.module.searchspace.BooleanFunctionGenotype;

public class CaseSelection
extends Selection
implements Configurable {
    private double threshold = 25.0;

    public CaseSelection(OperatorGraph graph) {
        super(graph);
        super.addInPort();
        super.addOutPort();
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
    }

    public IndividualList[] process(IndividualList[] original) {
        if (original[0].size() == 0) {
            IndividualList[] result = new IndividualList[]{new Population(this.getOperatorGraph().getSchedule())};
            return result;
        }
        IndividualList[] result = new IndividualList[1];
        Individual[] origin = original[0].toArray();
        result[0] = new Population(this.graph.getSchedule());
        int i = 0;
        while (i < origin.length) {
            BooleanFunctionGenotype bfg = (BooleanFunctionGenotype)origin[i].getGenotype();
            if ((double)bfg.evaluate1s() / (double)bfg.getNum1Rows() >= this.threshold / 100.0) {
                result[0].addIndividual(origin[i]);
            }
            ++i;
        }
        return result;
    }

    public Double getPropertyThreshold() {
        return new Double(this.threshold);
    }

    public void setPropertyThreshold(Double threshold) {
        this.threshold = threshold;
    }

    public String getShortDescriptionForThreshold() {
        return "Min. for fulfilled 1-lines.";
    }

    public String getLongDescriptionForThreshold() {
        return "Minimum percentage of fulfilled 1-lines for selected individuals.";
    }

    public String getName() {
        return "CaseSelection";
    }

    public String getDescription() {
        return "Selects all individuals whose DNFTree fulfilles more than threshold percent of the 1-lines.";
    }
}

