/*
 * Decompiled with CFR 0.152.
 */
package freak.module.stoppingcriterion;

import freak.core.control.Schedule;
import freak.core.event.EventListener;
import freak.core.event.GenerationEvent;
import freak.core.event.GenerationEventListener;
import freak.core.event.RunEvent;
import freak.core.event.RunEventListener;
import freak.core.modulesupport.Configurable;
import freak.core.stoppingcriterion.AbstractStoppingCriterion;

public class Duration
extends AbstractStoppingCriterion
implements Configurable,
GenerationEventListener,
RunEventListener {
    private int duration = 30;
    private double startTime;

    public Duration(Schedule schedule) {
        super(schedule);
    }

    public String getName() {
        return "Duration";
    }

    public String getDescription() {
        return "Stops a run after the specified duration in seconds.";
    }

    public void setPropertyDuration(Integer i) {
        if (i > 0) {
            this.duration = i;
        }
    }

    public Integer getPropertyDuration() {
        return new Integer(this.duration);
    }

    public String getLongDescriptionForDuration() {
        return "The time after which the run is stopped in seconds.";
    }

    public void generation(GenerationEvent evt) {
        double time = this.getSchedule().getRunTime();
        if (time - this.startTime >= (double)this.duration) {
            this.stopRun();
        }
    }

    public void createEvents() {
        this.schedule.getEventController().addEvent((EventListener)this, GenerationEvent.class, this.schedule);
        this.schedule.getEventController().addEvent((EventListener)this, RunEvent.class, this.schedule);
    }

    public void runStarted(RunEvent evt) {
        this.startTime = this.getSchedule().getRunTime();
    }
}

