/*
 * Decompiled with CFR 0.152.
 */
package javalain.j2d;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;
import util.GuiUtils;

public class JpGraph
extends JPanel {
    private int largeur;
    private int hauteur;
    private int marge_haut = 25;
    private int marge_gauche = 50;
    private int marge_bas = 50;
    private int marge_droite = 25;
    private int taille_point = 2;
    private int decal_point = (this.taille_point - 1) / 2;
    private int centre_y;
    private double[] coord;
    private double x_min;
    private double x_max;
    private double y_min;
    private double y_max;
    private int indiceFinCoord;

    public JpGraph(int l, int h) {
        this.largeur = l;
        this.hauteur = h;
        this.centre_y = this.hauteur - 1 - this.marge_bas;
        this.setMinimumSize(new Dimension(this.largeur, this.hauteur));
        this.setPreferredSize(new Dimension(this.largeur, this.hauteur));
        this.coord = new double[100];
        this.indiceFinCoord = -1;
    }

    public int getMargeGauche() {
        return this.marge_gauche;
    }

    public int getMargeDroite() {
        return this.marge_droite;
    }

    public int getMargeHaut() {
        return this.marge_haut;
    }

    public int getMargeBas() {
        return this.marge_bas;
    }

    public void raz() {
        this.indiceFinCoord = -1;
    }

    public void addNombre(double x, double y) {
        int taille;
        if (this.indiceFinCoord == -1) {
            this.x_min = x;
            this.x_max = x;
            this.y_min = y;
            this.y_max = y;
        }
        if (this.indiceFinCoord >= (taille = this.coord.length) - 2) {
            int n_taille = taille * 120 / 100 + 1;
            double[] tab = this.coord;
            this.coord = new double[n_taille];
            System.arraycopy(tab, 0, this.coord, 0, taille);
        }
        if (x > this.x_max) {
            this.x_max = x;
        } else if (x < this.x_min) {
            this.x_min = x;
        }
        if (y > this.y_max) {
            this.y_max = y;
        } else if (y < this.y_min) {
            this.y_min = y;
        }
        this.coord[++this.indiceFinCoord] = x;
        this.coord[++this.indiceFinCoord] = y;
    }

    public void paint(Graphics g) {
        g.setColor(GuiUtils.VERT_LEGER);
        g.fillRect(0, 0, this.largeur, this.hauteur);
        double echelleX = (double)(this.largeur - this.marge_gauche - this.marge_droite - this.taille_point) / (this.x_max - this.x_min);
        double echelleY = (double)(this.hauteur - this.marge_bas - this.marge_haut - this.taille_point) / (this.y_max - this.y_min);
        g.setColor(Color.GRAY);
        g.drawLine(this.marge_gauche, this.centre_y, this.largeur - 1 - this.marge_droite, this.centre_y);
        g.drawString("" + GuiUtils.DECIMAL_3.format(this.x_min), this.marge_gauche, this.centre_y + 15);
        g.drawString("" + GuiUtils.DECIMAL_3.format(this.x_max), this.largeur - 1 - this.marge_droite - 35, this.centre_y + 15);
        g.drawLine(this.marge_gauche, this.marge_haut, this.marge_gauche, this.centre_y);
        g.drawString("" + GuiUtils.DECIMAL_3.format(this.y_min), this.marge_gauche - 35, this.centre_y - 5);
        g.drawString("" + GuiUtils.DECIMAL_3.format(this.y_max), this.marge_gauche - 35, this.marge_haut);
        g.setColor(Color.BLACK);
        for (int i = 0; i < (this.indiceFinCoord + 1) / 2; ++i) {
            g.fillRect((int)((this.coord[i * 2] - this.x_min) * echelleX) + this.marge_gauche - this.decal_point, this.centre_y - (int)((this.coord[i * 2 + 1] - this.y_min) * echelleY) - this.decal_point, this.taille_point, this.taille_point);
        }
    }
}

