/*
 * Decompiled with CFR 0.152.
 */
package javalain.algorithmegenetique.gene;

import javalain.algorithmegenetique.Gene;
import javalain.algorithmegenetique.gene.Trit;

public final class Bit
extends Gene {
    private char valeur;

    public Bit() {
        this.valeur = Math.random() < 0.5 ? (char)48 : (char)49;
    }

    private Bit(char c) {
        this.valeur = c;
    }

    public void set(char c) {
        if (c != '0' && c != '1') {
            throw new IllegalArgumentException("Bit, set (char c) : caractere non valide ('0' ou '1').");
        }
        this.valeur = c;
    }

    public char get() {
        return this.valeur;
    }

    public Gene melanger(Gene g) {
        if (this.valeur == ((Bit)g).valeur) {
            return new Bit(this.valeur);
        }
        return new Bit();
    }

    public void mutation() {
        this.valeur = Math.random() < 0.5 ? (char)48 : (char)49;
    }

    public Gene copier() {
        return new Bit(this.valeur);
    }

    public Gene creer() {
        return new Bit();
    }

    public boolean estEgalA(Gene g) {
        if (g instanceof Bit) {
            return this.valeur == ((Bit)g).valeur;
        }
        if (g instanceof Trit) {
            return this.valeur == ((Trit)g).get();
        }
        return false;
    }

    public StringBuilder afficher() {
        return new StringBuilder().append(this.valeur);
    }
}

