/*
 * Decompiled with CFR 0.152.
 */
package javalain.algorithmegenetique;

import javalain.algorithmegenetique.Population;
import javalain.algorithmegenetique.ihm.ControleAlgoG;

public abstract class EvolutionGA
implements Runnable {
    public static final int EXECUTABLE = 0;
    public static final int MARCHE = 1;
    public static final int PAUSE = 2;
    public static final int DEMARRE = 5;
    public static final int TERMINE = 6;
    protected Population pop;
    protected int nbGeneration;
    protected long tpsSel;
    protected long tpsCrois;
    protected long tpsMut;
    protected long tpsFit;
    protected long tpsTotal;
    private boolean vivant;
    private int etat;
    protected ControleAlgoG controleur;

    public EvolutionGA(Population p) {
        Thread th = new Thread(this);
        this.vivant = true;
        this.etat = 0;
        if (p == null) {
            throw new RuntimeException("Evolution, Evolution (Population p) : la r\u00e9f\u00e9rence sur la population est nulle.");
        }
        this.pop = p;
        th.setPriority(1);
        th.start();
    }

    public Population getPopulation() {
        return this.pop;
    }

    public void setControleAlgoG(ControleAlgoG c) {
        this.controleur = c;
        this.controleur.setEvolution(this);
    }

    public ControleAlgoG getControleAlgoG() {
        return this.controleur;
    }

    public synchronized void setEtat(int e) {
        if (e != 0 && e != 5 && e != 1 && e != 2 && e != 6) {
            throw new IllegalArgumentException("Evolution, setEtat (int e) : \u00e9tat inconnu.");
        }
        this.etat = e;
        if (this.controleur != null) {
            this.controleur.updateEtatEvolution();
        }
    }

    public synchronized int getEtat() {
        return this.etat;
    }

    public void run() {
        long debut = 0L;
        block7: while (this.vivant) {
            switch (this.etat) {
                case 1: {
                    if (this.conditionEvolution()) {
                        this.pop.generation();
                        ++this.nbGeneration;
                        long fin = System.currentTimeMillis();
                        this.tpsTotal += fin - debut;
                        debut = fin;
                        this.tpsSel += this.pop.getDureeSelection();
                        this.tpsCrois += this.pop.getDureeCroisement();
                        this.tpsMut += this.pop.getDureeMutation();
                        this.tpsFit += this.pop.getDureeFitness();
                        if (this.controleur == null) continue block7;
                        this.controleur.setNbIndividu(this.pop.size());
                        this.controleur.setNbGeneration(this.nbGeneration);
                        this.controleur.setNoteMax(this.pop.getNoteMax());
                        this.controleur.setNoteMoyenne(this.pop.getNoteMoyenne());
                        this.controleur.setStatCpu(this.tpsSel, this.tpsCrois, this.tpsMut, this.tpsFit, this.tpsTotal);
                        continue block7;
                    }
                    this.etat = 6;
                    continue block7;
                }
                case 5: {
                    debut = System.currentTimeMillis();
                    this.pop.initialise();
                    this.nbGeneration = 0;
                    this.tpsSel = 0L;
                    this.tpsCrois = 0L;
                    this.tpsMut = 0L;
                    this.tpsFit = 0L;
                    this.tpsTotal = 0L;
                    if (this.controleur != null) {
                        this.controleur.demarre();
                    }
                    this.demarre();
                    this.setEtat(1);
                    continue block7;
                }
                case 6: {
                    if (this.controleur != null) {
                        this.controleur.termine();
                    }
                    this.setEtat(0);
                    this.termine();
                    continue block7;
                }
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            debut = System.currentTimeMillis();
        }
        if (this.controleur != null) {
            this.controleur.stop();
        }
    }

    public void stopEvolution() {
        this.vivant = false;
    }

    public abstract void demarre();

    public abstract void termine();

    public abstract boolean conditionEvolution();
}

