% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redcap-next-free-record-name.R
\name{redcap_next_free_record_name}
\alias{redcap_next_free_record_name}
\title{Determine free available record ID}
\usage{
redcap_next_free_record_name(
  redcap_uri,
  token,
  verbose = TRUE,
  config_options = NULL,
  handle_httr = NULL
)
}
\arguments{
\item{redcap_uri}{The
\href{https://en.wikipedia.org/wiki/Uniform_Resource_Identifier}{uri}/url
of the REDCap server
typically formatted as "https://server.org/apps/redcap/api/".
Required.}

\item{token}{The user-specific string that serves as the password for a
project.  Required.}

\item{verbose}{A boolean value indicating if \code{message}s should be printed
to the R console during the operation.  The verbose output might contain
sensitive information (\emph{e.g.} PHI), so turn this off if the output might
be visible somewhere public. Optional.}

\item{config_options}{A list of options passed to \code{\link[httr:POST]{httr::POST()}}.
See details at \code{\link[httr:httr_options]{httr::httr_options()}}. Optional.}

\item{handle_httr}{The value passed to the \code{handle} parameter of
\code{\link[httr:POST]{httr::POST()}}.
This is useful for only unconventional authentication approaches.  It
should be \code{NULL} for most institutions.  Optional.}
}
\value{
a \link[base:character]{base::character} vector of either
length 1 (if successful) or length 0 (if not successful).
}
\description{
Determines the next available record ID.
}
\details{
If the API call is unsuccessful, a value of \code{character(0)} will
be returned (\emph{i.e.}, an empty vector).  This ensures that a the function
will always return an object of class
\link[base:character]{base::character}.
}
\note{
\strong{Documentation in REDCap 8.4.0}

To be used by projects with record auto-numbering enabled, this method
exports the next potential record ID for a project. It generates the next
record name by determining the current maximum numerical record ID and then
incrementing it by one.

\if{html}{\out{<div class="sourceCode">}}\preformatted{Note: This method does not create a new record, but merely determines what
the next record name would be.

If using Data Access Groups (DAGs) in the project, this method accounts for
the special formatting of the record name for users in DAGs (e.g., DAG-ID);
in this case, it only assigns the next value for ID for all numbers inside
a DAG. For example, if a DAG has a corresponding DAG number of 223 wherein
records 223-1 and 223-2 already exist, then the next record will be 223-3
if the API user belongs to the DAG that has DAG number 223. (The DAG number
is auto-assigned by REDCap for each DAG when the DAG is first created.)

When generating a new record name in a DAG, the method considers all records
in the entire project when determining the maximum record ID, including
those that might have been originally created in that DAG but then later
reassigned to another DAG.

Note: This method functions the same even for projects that do not have
record auto-numbering enabled.
}\if{html}{\out{</div>}}
}
\examples{
uri      <- "https://redcap-dev-2.ouhsc.edu/redcap/api/"
token    <- "9A068C425B1341D69E83064A2D273A70"
# Returns 6
REDCapR::redcap_next_free_record_name(redcap_uri = uri, token = token)
}
