% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_redcap_tables.R
\name{read_redcap_tables}
\alias{read_redcap_tables}
\title{Download REDCap data}
\usage{
read_redcap_tables(
  uri,
  token,
  records = NULL,
  fields = NULL,
  events = NULL,
  forms = NULL,
  raw_or_label = c("raw", "label", "both"),
  split_forms = c("all", "repeating", "none"),
  ...
)
}
\arguments{
\item{uri}{REDCap database API uri}

\item{token}{API token}

\item{records}{records to download}

\item{fields}{fields to download}

\item{events}{events to download}

\item{forms}{forms to download}

\item{raw_or_label}{raw or label tags. Can be "raw", "label" or "both".

  * "raw": Standard \link[REDCapR]{redcap_read} method to get raw values.
  * "label": Standard \link[REDCapR]{redcap_read} method to get label values.
  * "both": Get raw values with REDCap labels applied as labels. Use
  \link[REDCapCAST]{as_factor} to format factors with original labels and use
  the  `gtsummary` package functions like \link[gtsummary]{tbl_summary} to
  easily get beautiful tables with original labels from REDCap. Use
  \link[REDCapCAST]{fct_drop} to drop empty levels.}

\item{split_forms}{Whether to split "repeating" or "all" forms, default is
all. Give "none" to export native semi-long REDCap format}

\item{...}{passed on to \link[REDCapR]{redcap_read}}
}
\value{
list of instruments
}
\description{
Implementation of passed on to \link[REDCapCAST]{REDCap_split} with a focused
data acquisition approach using passed on to \link[REDCapR]{redcap_read} and
only downloading specified fields, forms and/or events using the built-in
focused_metadata including some clean-up.
Works with classical and longitudinal projects with or without repeating
instruments.
Will preserve metadata in the data.frames as labels.
}
\examples{
# Examples will be provided later
}
