% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WLVmix.R
\name{WLVmix}
\alias{WLVmix}
\title{NPMLE for Longitudinal Gaussian Means and Variances Model with Independent Prior}
\usage{
WLVmix(y, id, w, u = 300, v = 300, eps = 1e-04, maxit = 2, ...)
}
\arguments{
\item{y}{A vector of observations}

\item{id}{A strata indicator vector indicating grouping of y}

\item{w}{A vector of weights corresponding to y}

\item{u}{A vector of bin boundaries for the mean effects}

\item{v}{A vector of bin boundaries for the variance effects}

\item{eps}{Convergence tolerance for iterations}

\item{maxit}{A limit on the number of allowed iterations}

\item{...}{optional parameters to be passed to KWDual to control optimization}
}
\value{
A list consisting of the following components: 
     \item{u}{midpoints of the mean bin boundaries} 
     \item{fu}{the function values of the mixing density of the means } 
     \item{v}{midpoints of the variance bin boundaries} 
     \item{fv}{the function values of the mixing density of the variances.} 
     \item{logLik}{vector of log likelihood values for each iteration} 
     \item{du}{Bayes rule estimate of the mixing density means.} 
     \item{dv}{Bayes rule estimate of the mixing density variances.} 
     \item{status}{Mosek convergence status for each iteration}
}
\description{
A Kiefer-Wolfowitz NPMLE procedure for estimation of a Gaussian model with
independent mean and variance prior components with weighted longitudinal data.
This version iterates back and forth from Gamma and Gaussian forms of the likelihood.
}
\author{
J. Gu and R. Koenker
}
\references{
Gu, J. and R. Koenker (2015) Empirical Bayesball Remixed, preprint
}
\seealso{
WGLVmix for a more general bivariate mixing distribution version and
	WTLVmix for an alternative estimator exploiting a Student/Gamma decomposition
}
\keyword{nonparametric}

