% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/revgeo.R
\name{revgeo}
\alias{revgeo}
\title{Reversely Geocode a Czech Address}
\usage{
revgeo(coords)
}
\arguments{
\item{coords}{coordinates to be reverse geocoded; expected as \code{sf} data
frame of spatial points}
}
\description{
This function connects to Czech State Administration of Land Surveying and
Cadastre (\url{https://www.cuzk.cz/en}) API to reversely geocode an address.
As consequence it is implemented only for Czech addresses.
}
\details{
Input of the function is a \code{sf} data frame of spatial points, and
output a vector of characters.

The function returns the same \code{sf} data frame as input, with added field
revgeocoded; it contains the result of operation. If the data frame contained
a column named revgeocoded it gets overwritten.

In case of reverse geocoding failures (e.g. coordinates outside of the Czech
Republic and therefore scope of ČÚZK) NA is returned.

Usage of the ČÚZK API is governed by ČÚZK Terms & Conditions -
\url{https://geoportal.cuzk.cz/Dokumenty/Podminky.pdf}.
}
\examples{
library(dplyr)
library(sf)

brno <- obce_polygony() \%>\% # shapefile of Brno
  filter(NAZ_OBEC == "Brno") \%>\%
  st_set_crs(5514) \%>\% # a planar CRS
  st_set_agr("constant") # to avoid raising a warning

pupek_brna <- st_centroid(brno) # calculate centroid

adresa_pupku <- revgeo(pupek_brna)$revgeocoded # address of the center
}
