% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ellipse.R
\name{ellipse}
\alias{ellipse}
\title{Return ellipse points}
\usage{
ellipse(
  saxes = c(1, 1),
  loc = c(0, 0),
  theta = 0,
  n = 201,
  method = c("default", "angle", "distance")
)
}
\arguments{
\item{saxes}{a \eqn{(2 \times 1)} vector of the length of the ellipse semi-axes.}

\item{loc}{a \eqn{(2 \times 1)} vector of the Cartesian coordinates of the ellipse center.}

\item{theta}{the angle of rotation of the elllipse (in radians).}

\item{n}{the number of points returned by the function.}

\item{method}{The method used to return the points: either \code{"default"}, \code{"angle"}, or \code{"distance"} (see Details).}
}
\value{
A \eqn{(n \times 2)} matrix whose columns correspond to the Cartesian coordinates of the points lying on the ellipse.
}
\description{
Return ellipse points. Usefull for ploting ellipses.
}
\details{
\describe{
  \item{\code{"default"}}{returns points according to the polar equation;}
  \item{\code{"angle"}}{returns points radially equidistant;}
  \item{\code{"distance"}}{ returns points that are equidistant on the ellipse arc.}
}
}
\examples{
# Ellipse parameters
saxes <- c(5,2)
loc <- c(0,0)
theta <- pi/4

# Plot
plot(ellipse(saxes, loc, theta, n=500),type="l")
points(ellipse(saxes, loc, theta, n=30),pch=20,col="red")
points(ellipse(saxes, loc, theta, n=30, method="angle"),pch=20,col="blue")
points(ellipse(saxes, loc, theta, n=30, method="distance"),pch=20,col="green")
}
