% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cofactor.R
\name{cofactor}
\alias{cofactor}
\alias{minor}
\title{\eqn{(i,j)}-cofactor and \eqn{(i,j)}-minor of a matrix}
\usage{
cofactor(A, i, j)

minor(A, i, j)
}
\arguments{
\item{A}{a square matrix.}

\item{i}{the \eqn{i}-th row.}

\item{j}{the \eqn{j}-th column.}
}
\value{
The \eqn{(i,j)}-minor/cofactor of the matrix \eqn{A} (single value).
}
\description{
Compute the \eqn{(i,j)}-cofactor, respectively the \eqn{(i,j)}-minor of 
the matrix \eqn{A}. The \eqn{(i,j)}-cofactor is obtained by multiplying 
the \eqn{(i,j)}-minor by \eqn{(-1)^{i+j}}. The \eqn{(i,j)}-minor of \eqn{A}, 
is the determinant of the \eqn{(n - 1) \times (n - 1)} matrix that results 
by deleting the \eqn{i}-th row and the \eqn{j}-th column of \eqn{A}.
}
\examples{
A <- matrix(c(1,4,5,3,7,2,2,8,3),nrow=3,ncol=3)
A
minor(A,2,3)
cofactor(A,2,3)
}
\seealso{
\code{\link{adjoint}}
}
