% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_dashboard.R
\name{call_dashboard}
\alias{call_dashboard}
\title{Visualizing validation results according to four steps, namely, set-selection, estimation, diagnosis, and validation}
\usage{
call_dashboard(source.obj = NULL, target.obj = NULL, source.obj.rep = NULL)
}
\arguments{
\item{source.obj}{an instantiated object of class \code{TEstimator}. The estimates of conditional average treatment effects are compared to those from \code{target.obj}.}

\item{target.obj}{an instantiated object of class \code{TEstimator}. The estimates of conditional average treatment effects are regarded as unbiased of truth.}

\item{source.obj.rep}{an instantiated object of class \code{SEstimator}. The estimates of conditional average treatment effects are compared to those from \code{target.obj}.}
}
\value{
an interactive interface visualizing results of four steps
}
\description{
Visualizing validation results according to four steps, namely, set-selection, estimation, diagnosis, and validation
}
\examples{
\donttest{
source.data <- RCTrep::source.data[sample(dim(RCTrep::source.data)[1],500),]
target.data <- RCTrep::target.data[sample(dim(RCTrep::target.data)[1],500),]

vars_name <- list(confounders_treatment_name = c("x1","x2","x3","x4","x5","x6"),
                  treatment_name = c('z'),
                  outcome_name = c('y')
)
confounders_sampling_name <- c("x2","x6")

source.obj <- TEstimator_wrapper(
 Estimator = "G_computation",
 data = source.data,
 vars_name = vars_name,
 outcome_method = "glm",
 outcome_form=y ~ x1 + x2 + x3 + z + z:x1 + z:x2 +z:x3+ z:x6,
 name = "RWD",
 data.public = FALSE
)

target.obj <- TEstimator_wrapper(
 Estimator = "Crude",
 data = target.data,
 vars_name = vars_name,
 name = "RCT",
 data.public = FALSE,
 isTrial = TRUE
)

strata <- c("x1","x4")
source.rep.obj <- SEstimator_wrapper(Estimator = "Exact",
                                     target.obj = target.obj,
                                     source.obj = source.obj,
                                     confounders_sampling_name =
                                     confounders_sampling_name)
source.rep.obj$EstimateRep(stratification = strata, stratification_joint = TRUE)

call_dashboard(source.obj = source.obj,
               target.obj = target.obj,
               source.obj.rep = source.obj.rep)

}
}
