% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-MA.R
\name{plotMA}
\alias{plotMA}
\title{Plot MA plot from DE analysis results}
\usage{
plotMA(
  DEResult,
  pThreshold = 0.05,
  useFDR = TRUE,
  logFCThreshold = 1,
  labels = NULL,
  fitMethod = "loess"
)
}
\arguments{
\item{DEResult}{A data frame with DE analysis results.
The columns are ID, p.value, pFDR, logFC, and aveExpr.}

\item{pThreshold}{The p-value threshold to color significant points.}

\item{useFDR}{Use FDR instead of p-value for significance.}

\item{logFCThreshold}{The log2 fold change threshold to color significant points.}

\item{labels}{named vector of labels to use for points, e.g., c("gene1" = "Gene 1", "gene2" = "Gene 2")}

\item{fitMethod}{The method to use for fitting the loess line.
If NULL then no line is drawn.}
}
\value{
A ggplot object.
}
\description{
Plot MA plot from DE analysis results
}
\examples{
\donttest{
library(RCPA)
library(SummarizedExperiment)

RNASeqDEExperiment <- loadData("RNASeqDEExperiment")
RCPA::plotMA(rowData(RNASeqDEExperiment), logFCThreshold = 0.5) + ggtitle("RNASeq - GSE153873")

}
}
