% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneset-analysis.R
\name{runGeneSetAnalysis}
\alias{runGeneSetAnalysis}
\title{Geneset Enrichment Analysis}
\usage{
runGeneSetAnalysis(
  summarizedExperiment,
  genesets,
  method = c("ora", "fgsea", "gsa", "ks", "wilcox"),
  ORAArgs = list(pThreshold = 0.05),
  FgseaArgs = list(sampleSize = 101, minSize = 1, maxSize = Inf, eps = 1e-50, scoreType =
    "std", nproc = 0, gseaParam = 1, BPPARAM = NULL, nPermSimple = 1000, absEps = NULL),
  GSAArgs = list(method = "maxmean", random.seed = NULL, knn.neighbors = 10, s0 = NULL,
    s0.perc = NULL, minsize = 15, maxsize = 500, restand = TRUE, restand.basis =
    "catalog", nperms = 200, xl.mode = "regular", xl.time = NULL, xl.prevfit = NULL)
)
}
\arguments{
\item{summarizedExperiment}{The generated SummarizedExpriment object from DE analysis result.}

\item{genesets}{The genesets definition, ex. KEGG genesets from getGeneSets function.}

\item{method}{The geneset analsyis method, including ORA, fgsea, GSA, ks, and wilcox.}

\item{ORAArgs}{A list of other passed arguments to ORA. pThreshold is used as p.value cutoff to pick DE genes.}

\item{FgseaArgs}{A list of other passed arguments to fgsea. See fgsea function.}

\item{GSAArgs}{A list of other passed arguments to GSA. See GSA function.}
}
\value{
A dataframe of geneset analysis result
}
\description{
This function performs geneset analysis using either ORA, fgsea, GSA, ks, or wilcox approaches.
}
\examples{
\donttest{

library(RCPA)
RNASeqDEExperiment <- loadData("RNASeqDEExperiment")
genesets <- loadData("genesets")
oraResult <- runGeneSetAnalysis(RNASeqDEExperiment, genesets,
                                          method = "ora", ORAArgs = list(pThreshold = 0.05))
fgseaResult <- runGeneSetAnalysis(RNASeqDEExperiment, genesets, method = "fgsea",
                                            FgseaArgs = list(minSize = 10, maxSize = Inf))

}
}
