% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{get_pps}
\alias{get_pps}
\title{Extract prepositional phrases of row and column labels}
\usage{
get_pps(
  labels,
  notation = RCLabels::bracket_notation,
  prepositions = RCLabels::prepositions
)
}
\arguments{
\item{labels}{A list or vector of labels from which nouns are to be extracted.}

\item{notation}{The notation type to be used when extracting nouns.
Default is \code{RCLabels::bracket_notation}.}

\item{prepositions}{A list of prepositions, used to detect prepositional phrases.
Default is \code{RCLabels::prepositions}.}
}
\value{
All prepositional phrases in a suffix.
}
\description{
This function extracts the suffix of a row or column label as a
single string.
}
\examples{
get_pps(c("a [in b]", "c [of d]"))
get_pps(c("a [of b in c]", "d [-> e of f]"))
}
