% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notation.R
\name{row-col-notation}
\alias{row-col-notation}
\alias{notation_vec}
\alias{preposition_notation}
\alias{split_pref_suff}
\alias{paste_pref_suff}
\alias{flip_pref_suff}
\alias{keep_pref_suff}
\alias{switch_notation}
\title{Row and column notation}
\usage{
notation_vec(
  sep = " -> ",
  pref_start = "",
  pref_end = "",
  suff_start = "",
  suff_end = ""
)

preposition_notation(preposition, suff_start = " [", suff_end = "]")

split_pref_suff(x, notation = RCLabels::arrow_notation, transpose = FALSE)

paste_pref_suff(
  ps = list(pref = pref, suff = suff),
  pref = NULL,
  suff = NULL,
  notation = RCLabels::arrow_notation
)

flip_pref_suff(x, notation = RCLabels::arrow_notation)

keep_pref_suff(
  x,
  keep = c("pref", "suff"),
  notation = RCLabels::arrow_notation
)

switch_notation(x, from, to, flip = FALSE)
}
\arguments{
\item{sep}{A string separator between prefix and suffix. Default is " -> ".}

\item{pref_start}{A string indicating the start of a prefix. Default is \code{NULL}.}

\item{pref_end}{A string indicating the end of a prefix. Default is the value of \code{sep}.}

\item{suff_start}{A string indicating the start of a suffix. Default is the value of \code{sep}.}

\item{suff_end}{A string indicating the end of a suffix. Default is \code{NULL}.}

\item{preposition}{A string used to indicate position for energy flows, typically "from" or "to" in different notations.}

\item{x}{A string or vector of strings to be operated upon.}

\item{notation}{A notation vector generated by one of the \verb{*_notation()} functions, such as
\code{notation_vec()}, \code{arrow_notation}, or \code{bracket_notation}.
Default is \code{arrow_notation}.}

\item{transpose}{A boolean that tells whether to \code{purr::transpose()} the result.
Set \code{transpose = TRUE} when using \code{split_pref_suff()} in a \code{dplyr::mutate()}
call in the context of a data frame.
Default is \code{FALSE}.}

\item{ps}{A list of prefixes and suffixes in which each item of the list is itself a list with two items named \code{pref} and \code{suff}.}

\item{pref}{A string or list of strings that are prefixes. Default is \code{NULL}.}

\item{suff}{A string of list of strings that are suffixes. Default is \code{NULL}.}

\item{keep}{Tells which to keep, the prefix ("pref") or the suffix ("suff").}

\item{from}{The \code{notation} to switch \emph{away from}.}

\item{to}{The \code{notation} to switch \emph{to}.}

\item{flip}{A boolean that tells whether to also flip the notation. Default is \code{FALSE}.}
}
\value{
For \code{notation_vec()}, \code{arrow_notation}, and \code{bracket_notation},
a string vector with named items \code{pref_start}, \code{pref_end}, \code{suff_start}, and \code{suff_end};
For \code{split_pref_suff()}, a string list with named items \code{pref} and \code{suff}.
For \code{paste_pref_suff()}, \code{split_pref_suff()}, and \code{switch_notation()},
a string list in notation format specified by various \code{notation} arguments, including
\code{from}, and \code{to}.
For \code{keep_pref_suff}, one of the prefix or suffix or a list of prefixes or suffixes.
}
\description{
It is often convenient to represent row and column names
with notation that includes a prefix and a suffix,
with corresponding separators or start-end string sequences.
There are several functions that call \code{notation_vec()} to generate specialized versions
or otherwise manipulate row and column names on their own or as row or column names.
\itemize{
\item \code{notation_vec()} Builds a vector of notation symbols in a standard format
that is used by \code{matsbyname} in several places.
By default, it builds a list of notation symbols that provides an arrow
separator (" -> ") between prefix and suffix.
\item \code{preposition_notation()} Builds a list of notation symbols that provides (by default) square brackets around the suffix with a preposition ("prefix [preposition suffix]").
\item \code{paste_pref_suff()} \code{paste0}'s prefixes and suffixes, the inverse of \code{split_pref_suff()}.
\item \code{flip_pref_suff()} Switches the location of prefix and suffix, such that the prefix becomes the suffix, and
the suffix becomes the prefix.
E.g., "a -> b" becomes "b -> a" or "a [b]" becomes "b [a]".
\item \code{keep_pref_suff()} Selects only prefix or suffix, discarding notational elements
and the rejected part.
Internally, calls \code{split_pref_suff()} and selects only the \code{suff} portions.
\item \code{switch_notation()} Switches from one type of notation to another based on the \code{from} and \code{to} arguments.
Optionally, prefix and suffix can be \code{flip}ped.
\item \code{split_pref_suff()} Splits prefixes from suffixes, returning each in a list with names \code{pref} and \code{suff}.
If no prefix or suffix delimiters are found, \code{x} is returned in the \code{pref} item, unmodified,
and the \code{suff} item is returned as \code{""} (an empty string).
If there is no prefix, and empty string is returned for the \code{pref} item.
If there is no suffix, and empty string is returned for the \code{suff} item.
}

If \code{sep} only is specified (default is " -> "),
\code{pref_start}, \code{pref_end}, \code{suff_start}, and \code{suff_end} are
set appropriately.

None of the strings in a notation vector are considered part of the prefix or suffix.
E.g., "a -> b" in arrow notation means that "a" is the prefix and "b" is the suffix.
}
\examples{
notation_vec()
arrow_notation
bracket_notation
split_pref_suff("a -> b", notation = arrow_notation)
split_pref_suff(c("a -> b", "c -> d", "e -> f"), notation = arrow_notation)
split_pref_suff(c("a -> b", "c -> d", "e -> f"), notation = arrow_notation,
                transpose = TRUE)
flip_pref_suff("a [b]", notation = bracket_notation)
keep_pref_suff("a -> b", keep = "suff", notation = arrow_notation)
switch_notation("a -> b", from = arrow_notation, to = bracket_notation)
switch_notation("a -> b", from = arrow_notation, to = bracket_notation,
                flip = TRUE)
# Also works for vectors
switch_notation(c("a -> b", "c -> d"), from = arrow_notation, to = bracket_notation)
}
