\name{addCensored}
\alias{addCensored}
\title{
Add Censored ratetest to brownie object
}
\description{
This function adds a character string to the the commands slot of a brownie object (or list of brownie objects) which instructs the brownie program to run a censored ratetest.
}
\usage{
addCensored(obj, 
	file = NULL, 
	reps = 0, 
	taxset = character(0), 
	treeloop = FALSE, 
	charloop = FALSE, 
	quiet = FALSE, 
	usetempfile = FALSE, 
	...)
}
\arguments{
  \item{obj}{
A brownie object
}
  \item{file}{
The brownie core will write the output of the ratetest to this file (optional)
}
  \item{reps}{
Number of bootstrap repetitions to run; it also calculates the bootstrap p-value.  The default value is 0 when no bootstrapping is done.  Note that bootstrapping can add significant computational time to the analysis.
}
  \item{taxset}{
Taxa set which names the taxaset you are interested in comparing the rates of evolution over.  The inverse of this taxaset is automatically generated by the brownie core.  To see the list of taxasets for your brownie object, call \code{taxasets(obj)}.
}
  \item{treeloop}{
Should the analysis loop over all the trees in \code{obj}?  To use a specific tree then run the \code{addChoose(tree=<TREENUM>)} before this command.
}
  \item{charloop}{
Should the analysis loop over all the characters in \code{obj}?  To use a specific character then run the \code{addChoose(char=<CHARNUM>)} before this command.
}
  \item{quiet}{
Verbose output (only output to screen, output to file does not change)
}
  \item{usetempfile}{
Should a tempfile be written to (instead of file).  Not currently used.
}
  \item{\dots}{
Not currently used.
}
}
\details{
The censored ratetest compares the rates of evolution in a monophyletic clade to another monophyletic of paraphyletic clade (i.e. rate change only occurs at nodes).  It is useful for asking questions about whether a key character has lead to increased rates of evolution.  It is 'censored' as it removes the branches that join the two clades together as it is not clear which clade to assign these branches to.
}
\value{
Returns the original object (\code{obj}) with ratetest command added to its \code{commands} slot.
}
\references{
%% ~put references to the literature/web site here ~
}
\author{
J. Conrad Stack
}
\note{
%%  ~~further notes~~
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{taxasets}},
\code{\link{addChoose}},
\code{\link{plot.censored}}
}
\examples{

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ methods }

