% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addRates.R
\name{addRates}
\alias{addRates}
\title{Visualizes the TPR and FPR on the RBP curve.}
\usage{
addRates(obj, plot.values = TRUE, digits = 3L, col = "black",
  thresh = obj$prev, thresh.label = "thresh")
}
\arguments{
\item{obj}{[\code{\link{RBPObj}}]\cr
Data container for RBP curve.}

\item{plot.values}{[\code{logical(1)}]\cr
Whether the values of the corresponding measure should be added to the plot?
Default is \code{FALSE}.}

\item{digits}{[\code{numeric(1)}]\cr
Indicates the number of decimal places for the values that are plotted when 
\code{plot.values = TRUE}.
Default is \code{3L}.}

\item{col}{[\code{character(1)} | \code{numeric(1)}]\cr
A specification for the plotting color.}

\item{thresh}{[\code{numeric(1)}]\cr
Threshold that is used to compute the true positve and false positive rate.
Default is prevalence.}

\item{thresh.label}{[\code{character(1)}]\cr
The label for the threshold that is plotted when \code{plot.values = TRUE}.}
}
\value{
[\code{invisible(NULL)}].
}
\description{
For a given threshold \code{tresh}, the true positive rate (TPR) 
and the false positive rate (FPR) can be visually assessed by the RBP curve 
by the intersection of the RBP curve with the horizontal lines at 
\code{-thresh} and \code{1 - thresh}, respectively.
}

