% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condition_set.R
\name{rah_condition_set}
\alias{rah_condition_set}
\title{Grouping multiple conditions for an Ahrefs API query}
\usage{
rah_condition_set(...)
}
\arguments{
\item{\dots}{multiple condition arguments created by \code{rah_condition} function}
}
\value{
character string of parameters for API
}
\description{
Grouping multiple conditions for an Ahrefs API query
}
\examples{
    \dontrun{
    first_condition <- RAhrefs::rah_condition(
      column_name = "first_seen",
      operator    = "GREATER_THAN",
      value       = "2018-01-01",
      is_date     = TRUE)

    second_condition <- RAhrefs::rah_condition(
      column_name = "links",
      operator    = "GREATER_THAN",
      value       = "10")

    final_condition <- RAhrefs::rah_condition_set(
      first_condition,
      second_condition)
 }
}
\seealso{
Other Ahrefs conditions: \code{\link{rah_condition}}
}
\concept{Ahrefs conditions}
