% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brar_select_au_unknown_var.r
\name{brar_select_au_unknown_var}
\alias{brar_select_au_unknown_var}
\title{Select au in Bayesian Response-Adaptive Randomization with a Control Group for Continuous Endpoint with Unknown Variances}
\usage{
brar_select_au_unknown_var(
  Pats,
  nMax,
  TimeToOutcome,
  enrollrate,
  N1,
  armn,
  N2,
  tp,
  armlabel,
  blocksize,
  mean,
  sd,
  minstart,
  deltaa,
  tpp,
  deltaa1,
  side,
  output = NULL,
  V01,
  a01,
  b01,
  m01,
  V02 = V01,
  V03 = V01,
  V04 = V01,
  V05 = V01,
  a02 = a01,
  a03 = a01,
  a04 = a01,
  a05 = a01,
  b02 = b01,
  b03 = b01,
  b04 = b01,
  b05 = b01,
  m02 = m01,
  m03 = m01,
  m04 = m01,
  m05 = m01,
  ...
)
}
\arguments{
\item{Pats}{the number of patients accrued within a certain time frame indicates the
count of individuals who have been affected by the disease during that specific period,
for example, a month or a day. If this number is 10, it represents that
10 people have got the disease within the specified time frame.}

\item{nMax}{the assumed maximum accrued number of patients with the disease in the population, this number
should be chosen carefully to ensure a sufficient number of patients are simulated,
especially when considering the delay mechanism.}

\item{TimeToOutcome}{the distribution of delayed response times or a fixed delay time for responses.
The delayed time could be a month, a week or any other time frame. When the unit changes,
the number of TimeToOutcome should also change. It can be in the format
of expression(rnorm( length( vStartTime ),30, 3)), representing delayed responses
with a normal distribution, where the mean is 30 days and the standard deviation is 3 days.}

\item{enrollrate}{probability that patients in the population can enroll in the trial.
This parameter is related to the number of people who have been affected by the disease in the population,
following an exponential distribution.}

\item{N1}{number of participants with equal randomization in the 'initialization' period.
Recommend using 10 percent of the total sample size.}

\item{armn}{number of total arms in the trial.}

\item{N2}{maximal sample size for the trial.}

\item{tp}{tuning parameter. Some commonly used numbers are 0.5, 1 and n/2N.}

\item{armlabel}{a vector of treatment labels with an example of c(1, 2), where 1 and 2 describe
how each arm is labeled in a two-armed trial.}

\item{blocksize}{size of block used for equal randomization regarding participants in the 'initialization' period.
Recommend to be an even multiple of the number of total arms.}

\item{mean}{a vector of means in hypotheses, for example, as c(10,10) where 10 stands for the mean
in both groups. Another example is c(10,12) where 10 and 12 stand for the mean
for the control and the other treatment group, respectively.}

\item{sd}{a vector of standard deviations in hypotheses, for example, as c(2,2) where 2 stands for the standard deviation
in both groups. Another example is c(1,2) where 1 and 2 stand for the standard deviation
for the control and the other treatment group, respectively.}

\item{minstart}{a specified number of participants when one starts to check decision rules.}

\item{deltaa}{a vector of minimal effect expected to be observed for early futility stopping in
each arm is approximately \eqn{1\%}. The length of this parameter is \code{armn}-1.}

\item{tpp}{indicator of \code{tp} equals to n/2N. When \code{tp} is n/2N, \code{tpp} should be assigned 1. Default value is set to 0.}

\item{deltaa1}{a vector of pre-specified minimal effect size expected to be observed at the final stage
for each arm. The length of this parameter is \code{armn}-1.}

\item{side}{direction of a one-sided test, with values 'upper' or 'lower'.}

\item{output}{control the output of brar_select_au_binary. If the user does not specify anything, the function returns
the entire dataset used to select the stopping boundary for each iteration. If the user specifies 'B', the function
only returns the selected stopping boundary for each iteration.}

\item{V01, a01, b01, m01}{prior parameters m, V, a, b in \eqn{NIG(V,m,a,b)} of arm 1 in the trial, which stands for the control.}

\item{V02, a02, b02, m02}{prior parameters m, V, a, b in \eqn{NIG(V,m,a,b)} of arm 2 in the trial. Default value is set to \code{V01},
\code{a01}, \code{b01} and \code{m01}.}

\item{V03, a03, b03, m03}{prior parameters m, V, a, b in \eqn{NIG(V,m,a,b)} of arm 3 in the trial. Default value is set to \code{V01},
\code{a01}, \code{b01} and \code{m01}.}

\item{V04, a04, b04, m04}{prior parameters m, V, a, b in \eqn{NIG(V,m,a,b)} of arm 4 in the trial. Default value is set to \code{V01},
\code{a01}, \code{b01} and \code{m01}.}

\item{V05, a05, b05, m05}{prior parameters m, V, a, b in \eqn{NIG(V,m,a,b)} of arm 5 in the trial. Default value is set to \code{V01},
\code{a01}, \code{b01} and \code{m01}.}

\item{...}{additional arguments to be passed to \code{\link[stats]{integrate}} (such as rel.tol) from this function.}
}
\value{
A list of results generated from formula \eqn{Pr(\mu_k>\mu_{control}+\delta|data_{t-1})} at each step.
Note that before final stage of the trial, test statistics is calculated from \code{deltaa}, and test statistics is
calculated from \code{deltaa1} at the final stage.
}
\description{
\code{brar_select_au_unknown_var} involves selecting au in Bayesian Response-Adaptive Randomization with a control group
for continuous endpoints with unknown variance in trials with two to five arms. The conjugate prior distributions follow
Normal-Inverse-Gamma (NIG) (\eqn{(\mu,\sigma^2) \sim NIG(mean=m,variance=V \times \sigma^2,shape=a,rate=b)})
distributions and can be specified individually for each arm.
}
\details{
This function generates a data set or a value in one iteration for selecting the appropriate au using Bayesian
response-adaptive randomization with a control group under null hypotheses with no delay and delayed scenarios.
The function can handle trials with up to 5 arms for continuous outcomes with unknown variances. This function uses the formula
\eqn{\frac{Pr(\mu_k=max\{\mu_1,...,\mu_K\})^{tp}} {\sum_{k=1}^{K}{Pr(\mu_k=max\{\mu_1,...,\mu_K\})^{tp}}}} with \code{side} equals to 'upper',
and \eqn{\frac{Pr(\mu_k=min\{\mu_1,...,\mu_K\})^{tp}} {\sum_{k=1}^{K}{Pr(\mu_k=min\{\mu_1,...,\mu_K\}){tp}}}} 
with \code{side} equals to 'lower', utilizing available data at each step.
Considering the delay mechanism, \code{Pats} (the number of patients accrued within a certain time frame),
\code{nMax} (the assumed maximum accrued number of patients with the disease in the population) and 
\code{TimeToOutcome} (the distribution of delayed response times or a fixed delay time for responses) 
are parameters in the functions adapted from \url{https://github.com/kwathen/IntroBayesianSimulation}.
Refer to the website for more details.
}
\examples{
#brar_select_au_unknown_var with delayed responses follow a normal distribution with
#a mean of 60 days and a standard deviation of 3 days, where 
#mean=c((9.1/100+8.74/100+8.74/100)/3,(9.1/100+8.74/100+8.74/100)/3,
#(9.1/100+8.74/100+8.74/100)/3),sd=c(0.009,0.009,0.009),tp=1 and 
#the minimal effect size is 0. All arms have the same prior distributions.
set.seed(789)
stopbound1<-lapply(1:5,function(x){
brar_select_au_unknown_var(Pats=10,nMax=50000,TimeToOutcome=expression(rnorm(
length( vStartTime ),30, 3)), enrollrate=0.1, N1=48, armn=3, N2=480, tp=1,
armlabel=c(1,2,3), blocksize=6, mean=c((9.1/100+8.74/100+8.74/100)/3,
(9.1/100+8.74/100+8.74/100)/3,(9.1/100+8.74/100+8.74/100)/3) ,
sd=c(0.009,0.009,0.009),minstart=48, deltaa=c(-0.0003,-0.00035), tpp=0, 
deltaa1=c(0,0),V01=1/2,a01=0.3,m01=9/100,b01=0.00001,side='lower')
})

simf<-list()
simf1<-list()
for (xx in 1:5){
 if (any(stopbound1[[xx]][48:479,2]<0.01)){
      simf[[xx]]<-NA
   }  else{
      simf[[xx]]<-stopbound1[[xx]][480,2]
 }
 if (any(stopbound1[[xx]][48:479,3]<0.01)){
      simf1[[xx]]<-NA
   }  else{
      simf1[[xx]]<-stopbound1[[xx]][480,3]
 }
}
simf2<-do.call(rbind,simf)
sum(is.na(simf2)) #1, achieve around 20\% futility
simf3<-do.call(rbind,simf1)
sum(is.na(simf3)) #1, achieve around 20\% futility
stopbound1a<-cbind(simf2,simf3)
stopbound1a[is.na(stopbound1a)] <- 0
sum(stopbound1a[,1]>0.85 | stopbound1a[,2]>0.85)/5 #0.2
#the selected stopping boundary is 0.85 with an overall lower one-sided type 
#I error of 0.2, based on 5 simulations. Because it is under the permutation null hypothesis,
#the selected deltaa should be an average of -0.0003 and -0.00035 which is -0.000325.
#It is recommended to conduct more simulations (i.e., 1000)  
#to obtain an accurate deltaa and au. As the simulation number increases, the
#choice of deltaa could be consistent for comparisons of each arm to the control.
}
\references{
\insertRef{Wathen2017}{RARtrials}
}
