% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_for_RGWAS.R
\name{adjustGRM}
\alias{adjustGRM}
\title{Function to adjust genomic relationship matrix (GRM) with subpopulations}
\usage{
adjustGRM(
  y,
  X = NULL,
  ZETA,
  subpopInfo = NULL,
  nSubpop = 5,
  nPcsFindCluster = 10,
  include.epistasis = FALSE,
  package.MM = "gaston"
)
}
\arguments{
\item{y}{A \eqn{n \times 1} vector. A vector of phenotypic values should be used. NA is allowed.}

\item{X}{A \eqn{n \times p} matrix. You should assign mean vector (rep(1, n)) and covariates. NA is not allowed.}

\item{ZETA}{A list of variance matrices and its design matrices of random effects.
You can use only one kernel matrix for this function.
For example, ZETA = list(A = list(Z = Z.A, K = K.A)) (A for additive)
Please set names of lists "Z" and "K"!}

\item{subpopInfo}{The information on group memberships (e.g., subgroups for the population) will be required.
You can set a vector of group names (or clustering ids) for each genotype as this argument. This vector should be factor.}

\item{nSubpop}{When `subpopInfo = NULL`, `subpopInfo` will be automatically determined by using \code{\link[adegenet]{find.clusters}} function.
You should specify the number of groups by this argument to decide `subpopInfo`.}

\item{nPcsFindCluster}{Number of principal components to be used for `adegenet::find.clusters`.
This argument is used inly when `subpopInfo` is `NULL`.}

\item{include.epistasis}{Whether or not including the genome-wide epistastic effects into the model
to adjust ZETA.}

\item{package.MM}{The package name to be used when solving mixed-effects model. We only offer the following three packages:
"RAINBOWR", "MM4LMM" and "gaston". Default package is `gaston`.
See more details at \code{\link{EM3.general}}.}
}
\value{
\describe{ A List of
\item{$ZETAAdjust}{Adjusted ZETA including only one kernel.}
\item{$subpopInfo}{A vector of `subpopInfo` used in this function.}
\item{$covariates}{A matrix of covariates used in the mixed effects model.}
 #' \item{$nullModel}{Results of mixed-effects model for multiple kernels.}
\item{$nSubpop}{`nSubpop` used in this function.}
\item{$include.epistasis}{`include.epistasis` used in this function.}
}
}
\description{
Function to adjust genomic relationship matrix (GRM) with subpopulations
}
\references{
Rio S, Mary-Huard T, Moreau L, Bauland C, Palaffre C, et al. (2020)
Disentangling group specific QTL allele effects from
genetic background epistasis using admixed individuals in GWAS:
An application to maize flowering. PLOS Genetics 16(3): e1008241.
}
