% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{compute_fs_results}
\alias{compute_fs_results}
\title{Compute preliminary feature selection results for RAFS}
\usage{
compute_fs_results(data, decision, k, seeds, fs_fun = default_fs_fun)
}
\arguments{
\item{data}{input data where columns are variables and rows are observations (all numeric)}

\item{decision}{decision variable as a binary sequence of length equal to number of observations}

\item{k}{number of folds for internal cross validation}

\item{seeds}{a vector of seeds used for fold generation for internal cross validation}

\item{fs_fun}{function to compute feature selection p-values, it must have the same signature as \code{\link{default_fs_fun}} (which is the default, see its help to learn more)}
}
\value{
A \code{\link{list}} with feature selection results, e.g. from \code{\link{default_fs_fun}}.
}
\description{
This is a secondary function, useful when experimenting with different
feature selection filters and rankings. Its output is used in \code{\link{run_rafs_with_fs_results}}
and it is called for the user in \code{\link{run_rafs}}.
}
\examples{
library(MDFS)
mdfs_omp_set_num_threads(1)  # only to pass CRAN checks
data(madelon)
fs_results <- compute_fs_results(madelon$data, madelon$decision, 2, c(12345))
run_rafs_with_fs_results(madelon$data, madelon$decision, fs_results)
}
