% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectories.R
\name{trajectories}
\alias{trajectories}
\title{Plots MCMC chain trajectories}
\usage{
trajectories(object, Range = c(1, 5000), selected = NULL)
}
\arguments{
\item{object}{An \code{\link{mlwinfitMCMC-class}}, \code{\link[coda]{mcmc}} or \code{\link[coda]{mcmc.list}} object,
or other object that can be converted to an \code{\link[coda]{mcmc}} object.}

\item{Range}{An integer vector of length two specifying the first and last
iterations of the chains.}

\item{selected}{A character vector specifying the selected chains to be
plotted.}
}
\description{
This function draws trajectories of MCMC chains.
}
\examples{

\dontrun{
library(R2MLwiN)
# NOTE: if MLwiN not saved in location R2MLwiN defaults to, specify path via:
# options(MLwiN_path = 'path/to/MLwiN vX.XX/')
# If using R2MLwiN via WINE, the path may look like this:
# options(MLwiN_path = '/home/USERNAME/.wine/drive_c/Program Files (x86)/MLwiN vX.XX/')

## Example: tutorial
data(tutorial, package = "R2MLwiN")

(mymodel <- runMLwiN(normexam ~ 1 + standlrt + (1 + standlrt | student),
                     estoptions = list(EstM = 1), data = tutorial))

trajectories(mymodel, Range = c(4501, 5000))
}

}
\author{
Zhang, Z., Charlton, C.M.J., Parker, R.M.A., Leckie, G., and Browne,
W.J. (2016) Centre for Multilevel Modelling, University of Bristol.
}
\seealso{
\code{\link{sixway}}
}

