% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus.R
\name{subset_corpus}
\alias{subset_corpus}
\title{subset_corpus}
\usage{
subset_corpus(corpus, dtm, terms, exclude = FALSE, all = FALSE)
}
\arguments{
\item{corpus}{A \code{Corpus} object.}

\item{dtm}{A \code{DocumentTermMatrix} object corresponding to \code{corpus}.}

\item{terms}{One of more terms appearing in \code{dtm}.}

\item{exclude}{Whether documents containing the terms should be excluded rather than retained.}

\item{all}{Whether only documents containing all terms should be retained or excluded.
By default, documents need to contain at least one of the terms.}
}
\value{
\code{Corpus} object.
}
\description{
Select documents containing (or not containing) one or more terms.
}
\examples{

file <- system.file("texts", "reut21578-factiva.xml", package="tm.plugin.factiva")
corpus <- import_corpus(file, "factiva", language="en")
dtm <- build_dtm(corpus)
subset_corpus(corpus, dtm, "barrel")
subset_corpus(corpus, dtm, c("barrel", "opec"))
subset_corpus(corpus, dtm, c("barrel", "opec"), exclude=TRUE)
subset_corpus(corpus, dtm, c("barrel", "opec"), all=TRUE)

}
