% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuantumClone.R
\name{One_step_clustering}
\alias{One_step_clustering}
\title{Cellularity clustering}
\usage{
One_step_clustering(SNV_list, FREEC_list = NULL, contamination,
  nclone_range = 2:5, clone_priors = NULL, prior_weight = NULL,
  maxit = 8, preclustering = TRUE, simulated = FALSE, epsilon = 5 *
  (10^(-3)), save_plot = TRUE, ncores = 1, restrict.to.AB = FALSE,
  output_directory = NULL, model.selection = "BIC", optim = "default",
  keep.all.models = FALSE, force.single.copy = FALSE)
}
\arguments{
\item{SNV_list}{A list of dataframes (one for each sample), with as columns : (for the first column of the first sample the name of the sample),
the chromosome "Chr",the position of the mutation "Start", the number of reads supporting variant "Alt", as well as the total number of
reads overlapping position "Depth",
and if the output from FREEC for the samples are not associated, the genotype "Genotype".}

\item{FREEC_list}{list of dataframes from FREEC for each samples (usually named Sample_ratio.txt), in the same order as SNV_list}

\item{contamination}{Numeric vector giving the proportion of normal cells in each samples}

\item{nclone_range}{A number or range of clusters that should be used for clustering}

\item{clone_priors}{List of vectors with the putated position of clones}

\item{prior_weight}{Numeric with the proportion mutations in each clone}

\item{maxit}{Number of initial conditions to be tested for the EM algorithm}

\item{preclustering}{Boolean: should a kmeans be performed on A and AB sites to determine priors}

\item{simulated}{Should be TRUE if the data has been been generated by the QuantumCat algorithm}

\item{epsilon}{Stop value: maximal admitted value of the difference in cluster position and weights between two optimization steps.}

\item{save_plot}{Should the plots be saved? Default is TRUE}

\item{ncores}{Number of cores to be used during EM algorithm}

\item{restrict.to.AB}{Boolean: Should the analysis keep only sites located in A and AB sites in all samples?}

\item{output_directory}{Directory in which to save results}

\item{model.selection}{The function to minimize for the model selection: can be "AIC", "BIC", or numeric. In numeric, the function
uses a variant of the BIC by multiplication of the k*ln(n) factor. If >1, it will select models with lower complexity.}

\item{optim}{use L-BFS-G optimization from R ("default"), or from optimx ("optimx")}

\item{keep.all.models}{Should the function output the best model (default; FALSE), or all models tested (if set to true)}

\item{force.single.copy}{Should all mutations in overdiploid regions set to single copy? Default is FALSE}
}
\description{
Wrap up function that clusters cellularities. This is based on the most likely possibility for each mutation, give ints frequency and genotype.
}
\examples{
Mutations<-QuantumClone::Input_Example
 for(i in 1:2){
 Mutations[[i]]<-cbind(rep(paste("Example_",i,sep=""),times=10),Mutations[[i]])
 colnames(Mutations[[i]])[1]<-"Sample"
}
print("The data should look like this:")
print(head(Mutations[[1]]))

cat("Cluster data: will try to cluster between 3 and 4 clones, with 1 maximum search each time,
      and will use priors from preclustering (e.g. k-medoids on A and AB sites)")
print("The genotype is provided in the list frame, and
          there is no associated data from FREEC to get genotype from.")
print("The computation will run on a single CPU.")
Clustering_output<-QuantumClone(SNV_list = Mutations,
FREEC_list = NULL,contamination = c(0,0),nclone_range = 3:4,
clone_priors = NULL,prior_weight = NULL ,
maxit = 1,preclustering = TRUE, simulated = TRUE,
save_plot = TRUE,ncores=1,output_directory="Example")
print("The data can be accessed by Clustering_output$filtered_data")
print("All plots are now saved in the working directory")


}
\keyword{Clonal}
\keyword{inference}

