% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_fmx.R
\name{autolayer_fmx_continuous}
\alias{autolayer_fmx_continuous}
\title{Create \link[ggplot2]{layer} for Continuous \linkS4class{fmx} Objects}
\usage{
autolayer_fmx_continuous(
  object,
  type = c("density", "distribution"),
  data = object@data,
  epdf = object@epdf,
  probs = object@probs,
  xlim = if (!length(data)) qfmx(p = c(0.01, 0.99), dist = object) else
    range.default(data),
  hist.fill = "grey95",
  curve.col = 1,
  n = 1001L,
  ...
)
}
\arguments{
\item{object}{\linkS4class{fmx} object}

\item{type}{\link[base]{character} scalar.
Option \code{'density'} (default) plots the probability density for \linkS4class{fmx} input
(and the histogram if argument \code{data} is available).
Option \code{'distribution'} plots the cumulative probability distribution for \linkS4class{fmx} input
(and the empirical cumulative distribution if argument \code{data} is available).}

\item{data}{(optional) \link[base]{numeric} \link[base]{vector} of the observations.
Default is the slot \code{object@data}.}

\item{epdf}{(optional) empirical probability density \link[base]{function} returned by \link[stats]{approxfun}.
Default is the slot \code{object@epdf}}

\item{probs}{\link[base]{numeric} \link[base]{vector},
the percentages (to be) used in \link{QLMDe}, can be plotted as vertical lines.
Use \code{probs = NULL} to suppress the printing of these lines.}

\item{xlim}{\link[base]{numeric} length-two \link[base]{vector}, horizontal range}

\item{hist.fill}{color of the body of histogram, default \code{'grey95'}}

\item{curve.col}{color of the density curve of the fitted finite mixture distribution.
Default \code{'black'}}

\item{n}{\link[base]{integer}, see \link[ggplot2]{stat_function}}

\item{...}{potential parameters of \link[ggplot2]{stat_function}}
}
\value{
Function \code{\link[=autolayer_fmx_continuous]{autolayer_fmx_continuous()}} returns a \link[base]{list} of \link[ggplot2]{layer}s.
}
\description{
..
}
\seealso{
\link[ggplot2]{autolayer}
}
