% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.cmprsk}
\alias{predict.cmprsk}
\title{Calculate the Failure Time Probability from a Competing Risks Regression Model}
\usage{
\S3method{predict}{cmprsk}(object, newdata = NULL, time, lps, \dots)
}
\arguments{
\item{object}{A model fit by \code{\link[QHScrnomo]{crr.fit}}}

\item{newdata}{A \code{data.frame} for prediction containing values of covariates in the model. If missing, the model development dataset (\code{object$cphdat}) is used.}

\item{time}{A single time point to calculate the failure probability}

\item{lps}{Should the linear predictor be returned instead of the failure probability? Defaults to \code{FALSE}.}

\item{...}{Additional arguments such as \code{cov2} as in \code{\link[cmprsk]{crr}}}
}
\value{
A vector of failure probabilities at the specified time point (or linear predictors if \code{lps=TRUE}) with length equal to the number of rows in \code{newdata}
}
\description{
Computes the predicted probability of the event of interest at a specified time point for a competing risks regression model fit by \code{\link[QHScrnomo]{crr.fit}}. This function is adapted from \code{\link[cmprsk]{predict.crr}}.
}
\examples{
dd <- datadist(prostate.dat)
options(datadist = "dd")
prostate.f <- cph(Surv(TIME_EVENT,EVENT_DOD == 1) ~ TX  + rcs(PSA,3) +
           BX_GLSN_CAT +  CLIN_STG + rcs(AGE,3) +
           RACE_AA, data = prostate.dat,
           x = TRUE, y = TRUE, surv = TRUE,time.inc = 144)
prostate.crr <- crr.fit(prostate.f, cencode = 0, failcode = 1)
predict(prostate.crr, time = 60)

}
\references{
\code{ Fine JP and Gray RJ (1999)} A proportional hazards model
for the subdistribution of a competing risk.  \code{JASA} 94:496-509.
}
\seealso{
\code{\link[QHScrnomo]{crr.fit}}, \code{\link[cmprsk]{predict.crr}}
}
\author{
Michael W. Kattan, Ph.D. and Changhong Yu.\cr Department of
Quantitative Health Sciences, Cleveland Clinic
}
\keyword{datagen}
\keyword{survival}
